/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.Network;
import org.testcontainers.junit.jupiter.Testcontainers;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulClientConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulServerConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulSetup;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers.GenericContainer;

@Testcontainers
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/BaseEnvoyTest;", "", "()V", "Companion", "envoy-control-tests"})
public class BaseEnvoyTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Duration defaultDuration;
    @NotNull
    private static final Network network;
    @NotNull
    private static final EchoContainer echoContainer;
    @NotNull
    private static final EchoContainer echoContainer2;
    @NotNull
    private static final List<ConsulSetup> consulMastersInDc1;
    @NotNull
    private static final List<ConsulSetup> consulMastersInDc2;
    @NotNull
    private static ConsulSetup consulAgentInDc1;
    @NotNull
    private static ConsulSetup lowRpcConsulClient;
    @NotNull
    private static final ConsulOperations consulOperationsInFirstDc;
    @NotNull
    private static final ConsulOperations consulOperationsInSecondDc;
    private static final int consulHttpPort;
    private static final int consul2HttpPort;
    @NotNull
    private static final ConsulContainer consul;

    static {
        Duration duration = Duration.ofSeconds(90L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        defaultDuration = duration;
        Network network = Network.SHARED;
        Intrinsics.checkNotNullExpressionValue((Object)network, (String)"SHARED");
        BaseEnvoyTest.network = network;
        echoContainer = new EchoContainer(null, 1, null);
        echoContainer2 = new EchoContainer(null, 1, null);
        Object[] objectArray = new ConsulSetup[]{new ConsulSetup(BaseEnvoyTest.network, new ConsulServerConfig(1, "dc1", 0, null, 12, null), 0, 4, null), new ConsulSetup(BaseEnvoyTest.network, new ConsulServerConfig(2, "dc1", 0, null, 12, null), 0, 4, null), new ConsulSetup(BaseEnvoyTest.network, new ConsulServerConfig(3, "dc1", 0, null, 12, null), 0, 4, null)};
        consulMastersInDc1 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new ConsulSetup[]{new ConsulSetup(BaseEnvoyTest.network, new ConsulServerConfig(1, "dc2", 0, null, 12, null), 0, 4, null), new ConsulSetup(BaseEnvoyTest.network, new ConsulServerConfig(2, "dc2", 0, null, 12, null), 0, 4, null), new ConsulSetup(BaseEnvoyTest.network, new ConsulServerConfig(3, "dc2", 0, null, 12, null), 0, 4, null)};
        consulMastersInDc2 = CollectionsKt.listOf((Object[])objectArray);
        consulOperationsInFirstDc = consulMastersInDc1.get(0).getOperations();
        consulOperationsInSecondDc = consulMastersInDc2.get(0).getOperations();
        consulHttpPort = consulMastersInDc1.get(0).getPort();
        consul2HttpPort = consulMastersInDc2.get(0).getPort();
        consul = consulMastersInDc1.get(0).getContainer();
        echoContainer.start();
        echoContainer2.start();
        BaseEnvoyTest.Companion.setupMultiDcConsul();
        consulAgentInDc1 = new ConsulSetup(BaseEnvoyTest.network, new ConsulClientConfig(1, "dc1", consul.ipAddress(), null, 8, null), 0, 4, null);
        consulAgentInDc1.getContainer().start();
        lowRpcConsulClient = BaseEnvoyTest.Companion.setupLowRpcConsulClient();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u0002012\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\u001aJ\u000e\u00106\u001a\u0002012\u0006\u00103\u001a\u000204J$\u00107\u001a\u0002012\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\f\u00109\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0002J0\u0010:\u001a\u0002042\u0006\u00103\u001a\u0002042\u0006\u0010;\u001a\u0002042\u0006\u0010<\u001a\u0002042\u0006\u0010=\u001a\u00020\b2\b\b\u0002\u00105\u001a\u00020\u001aJT\u0010:\u001a\u0002042\b\b\u0002\u00103\u001a\u0002042\u0006\u0010;\u001a\u0002042\f\b\u0002\u0010>\u001a\u0006\u0012\u0002\b\u00030?2\b\b\u0002\u0010=\u001a\u00020\b2\b\b\u0002\u00105\u001a\u00020\u001a2\b\b\u0002\u0010@\u001a\u00020A2\u000e\b\u0002\u0010B\u001a\b\u0012\u0004\u0012\u0002040\u0014J\u0018\u0010C\u001a\u0002042\u0006\u0010;\u001a\u0002042\b\b\u0002\u0010D\u001a\u00020$J$\u0010E\u001a\u0002042\u0006\u0010;\u001a\u0002042\u0006\u0010F\u001a\u00020G2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002040\u0014J\b\u0010H\u001a\u00020\fH\u0002J\b\u0010I\u001a\u000201H\u0002J\u0016\u0010J\u001a\u0002012\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u001a\u0010)\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u000e\"\u0004\b+\u0010\u0010R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006L"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/BaseEnvoyTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulContainer;", "getConsul", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulContainer;", "consul2HttpPort", "", "getConsul2HttpPort", "()I", "consulAgentInDc1", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulSetup;", "getConsulAgentInDc1", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulSetup;", "setConsulAgentInDc1", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulSetup;)V", "consulHttpPort", "getConsulHttpPort", "consulMastersInDc1", "", "getConsulMastersInDc1", "()Ljava/util/List;", "consulMastersInDc2", "getConsulMastersInDc2", "consulOperationsInFirstDc", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulOperations;", "getConsulOperationsInFirstDc", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulOperations;", "consulOperationsInSecondDc", "getConsulOperationsInSecondDc", "defaultDuration", "Ljava/time/Duration;", "getDefaultDuration", "()Ljava/time/Duration;", "echoContainer", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoContainer;", "getEchoContainer", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoContainer;", "echoContainer2", "getEchoContainer2", "lowRpcConsulClient", "getLowRpcConsulClient", "setLowRpcConsulClient", "network", "Lorg/testcontainers/containers/Network;", "getNetwork", "()Lorg/testcontainers/containers/Network;", "deregisterAllServices", "", "deregisterService", "id", "", "consulOps", "deregisterServiceInRemoteDc", "joinClusters", "consulsInDc1", "consulsInDc2", "registerService", "name", "address", "port", "container", "Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer;", "registerDefaultCheck", "", "tags", "registerServiceInRemoteCluster", "target", "registerServiceWithEnvoyOnIngress", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;", "setupLowRpcConsulClient", "setupMultiDcConsul", "startConsulCluster", "consuls", "envoy-control-tests"})
    @SourceDebugExtension(value={"SMAP\nBaseEnvoyTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseEnvoyTest.kt\npl/allegro/tech/servicemesh/envoycontrol/config/BaseEnvoyTest$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,160:1\n1855#2:161\n1549#2:162\n1620#2,3:163\n1856#2:168\n1855#2,2:169\n1855#2:171\n1549#2:172\n1620#2,3:173\n1856#2:178\n37#3,2:166\n37#3,2:176\n*S KotlinDebug\n*F\n+ 1 BaseEnvoyTest.kt\npl/allegro/tech/servicemesh/envoycontrol/config/BaseEnvoyTest$Companion\n*L\n78#1:161\n79#1:162\n79#1:163,3\n78#1:168\n86#1:169,2\n89#1:171\n90#1:172\n90#1:173,3\n89#1:178\n79#1:166,2\n90#1:176,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getDefaultDuration() {
            return defaultDuration;
        }

        @NotNull
        public final Network getNetwork() {
            return network;
        }

        @NotNull
        public final EchoContainer getEchoContainer() {
            return echoContainer;
        }

        @NotNull
        public final EchoContainer getEchoContainer2() {
            return echoContainer2;
        }

        @NotNull
        public final List<ConsulSetup> getConsulMastersInDc1() {
            return consulMastersInDc1;
        }

        @NotNull
        public final List<ConsulSetup> getConsulMastersInDc2() {
            return consulMastersInDc2;
        }

        @NotNull
        public final ConsulSetup getConsulAgentInDc1() {
            return consulAgentInDc1;
        }

        public final void setConsulAgentInDc1(@NotNull ConsulSetup consulSetup) {
            Intrinsics.checkNotNullParameter((Object)consulSetup, (String)"<set-?>");
            consulAgentInDc1 = consulSetup;
        }

        @NotNull
        public final ConsulSetup getLowRpcConsulClient() {
            return lowRpcConsulClient;
        }

        public final void setLowRpcConsulClient(@NotNull ConsulSetup consulSetup) {
            Intrinsics.checkNotNullParameter((Object)consulSetup, (String)"<set-?>");
            lowRpcConsulClient = consulSetup;
        }

        @NotNull
        public final ConsulOperations getConsulOperationsInFirstDc() {
            return consulOperationsInFirstDc;
        }

        @NotNull
        public final ConsulOperations getConsulOperationsInSecondDc() {
            return consulOperationsInSecondDc;
        }

        public final int getConsulHttpPort() {
            return consulHttpPort;
        }

        public final int getConsul2HttpPort() {
            return consul2HttpPort;
        }

        @NotNull
        public final ConsulContainer getConsul() {
            return consul;
        }

        private final ConsulSetup setupLowRpcConsulClient() {
            ConsulSetup client2 = new ConsulSetup(this.getNetwork(), new ConsulClientConfig(2, "dc1", this.getConsul().ipAddress(), CollectionsKt.listOf((Object)new File("testcontainers/consul-low-rpc-rate.json"))), 0, 4, null);
            client2.getContainer().start();
            return client2;
        }

        private final void setupMultiDcConsul() {
            this.startConsulCluster(this.getConsulMastersInDc1());
            this.startConsulCluster(this.getConsulMastersInDc2());
            this.joinClusters(this.getConsulMastersInDc1(), this.getConsulMastersInDc2());
        }

        /*
         * WARNING - void declaration
         */
        private final void joinClusters(List<ConsulSetup> consulsInDc1, List<ConsulSetup> consulsInDc2) {
            Iterable $this$forEach$iv = consulsInDc1;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                ConsulSetup consul = (ConsulSetup)element$iv;
                boolean bl = false;
                Iterable $this$map$iv = consulsInDc2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ConsulSetup consulSetup = (ConsulSetup)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getContainer().containerName());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] consulInDc2ContainerNames = thisCollection$iv.toArray(new String[0]);
                SpreadBuilder spreadBuilder = new SpreadBuilder(4);
                spreadBuilder.add((Object)"consul");
                spreadBuilder.add((Object)"join");
                spreadBuilder.add((Object)"-wan");
                spreadBuilder.addSpread((Object)consulInDc2ContainerNames);
                String[] args = (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]);
                consul.getContainer().execInContainer(Arrays.copyOf(args, args.length));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void startConsulCluster(List<ConsulSetup> consuls) {
            ConsulSetup consul;
            Iterable $this$forEach$iv = consuls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                consul = (ConsulSetup)element$iv;
                boolean bl = false;
                consul.getContainer().start();
            }
            $this$forEach$iv = consuls;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                consul = (ConsulSetup)element$iv;
                boolean bl = false;
                Iterable $this$map$iv = consuls;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ConsulSetup consulSetup = (ConsulSetup)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getContainer().containerName());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] consulContainerNames = thisCollection$iv.toArray(new String[0]);
                SpreadBuilder spreadBuilder = new SpreadBuilder(3);
                spreadBuilder.add((Object)"consul");
                spreadBuilder.add((Object)"join");
                spreadBuilder.addSpread((Object)consulContainerNames);
                String[] args = (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]);
                consul.getContainer().execInContainer(Arrays.copyOf(args, args.length));
            }
        }

        @NotNull
        public final String registerServiceWithEnvoyOnIngress(@NotNull String name, @NotNull EnvoyContainer envoy, @NotNull List<String> tags) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)envoy), (String)"envoy");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            return pl.allegro.tech.servicemesh.envoycontrol.config.BaseEnvoyTest$Companion.registerService$default(this, null, name, envoy, 5001, null, false, tags, 49, null);
        }

        @NotNull
        public final String registerService(@NotNull String id, @NotNull String name, @NotNull String address, int port, @NotNull ConsulOperations consulOps) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)consulOps, (String)"consulOps");
            return ConsulOperations.registerService$default(consulOps, id, name, address, port, false, null, null, 112, null);
        }

        public static /* synthetic */ String registerService$default(Companion companion, String string, String string2, String string3, int n, ConsulOperations consulOperations, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                consulOperations = companion.getConsulOperationsInFirstDc();
            }
            return companion.registerService(string, string2, string3, n, consulOperations);
        }

        @NotNull
        public final String registerService(@NotNull String id, @NotNull String name, @NotNull GenericContainer<?> container2, int port, @NotNull ConsulOperations consulOps, boolean registerDefaultCheck, @NotNull List<String> tags) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(container2, (String)"container");
            Intrinsics.checkNotNullParameter((Object)consulOps, (String)"consulOps");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            return ConsulOperations.registerService$default(consulOps, id, name, container2.ipAddress(), port, registerDefaultCheck, tags, null, 64, null);
        }

        public static /* synthetic */ String registerService$default(Companion companion, String string, String string2, GenericContainer genericContainer, int n, ConsulOperations consulOperations, boolean bl, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                String string3 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                string = string3;
            }
            if ((n2 & 4) != 0) {
                genericContainer = companion.getEchoContainer();
            }
            if ((n2 & 8) != 0) {
                n = 5678;
            }
            if ((n2 & 0x10) != 0) {
                consulOperations = companion.getConsulOperationsInFirstDc();
            }
            if ((n2 & 0x20) != 0) {
                bl = false;
            }
            if ((n2 & 0x40) != 0) {
                list = CollectionsKt.listOf((Object)"a");
            }
            return companion.registerService(string, string2, genericContainer, n, consulOperations, bl, list);
        }

        @NotNull
        public final String registerServiceInRemoteCluster(@NotNull String name, @NotNull EchoContainer target) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return pl.allegro.tech.servicemesh.envoycontrol.config.BaseEnvoyTest$Companion.registerService$default(this, string, name, target, 0, this.getConsulOperationsInSecondDc(), false, null, 104, null);
        }

        public static /* synthetic */ String registerServiceInRemoteCluster$default(Companion companion, String string, EchoContainer echoContainer, int n, Object object) {
            if ((n & 2) != 0) {
                echoContainer = companion.getEchoContainer();
            }
            return companion.registerServiceInRemoteCluster(string, echoContainer);
        }

        public final void deregisterService(@NotNull String id, @NotNull ConsulOperations consulOps) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)consulOps, (String)"consulOps");
            consulOps.deregisterService(id);
        }

        public static /* synthetic */ void deregisterService$default(Companion companion, String string, ConsulOperations consulOperations, int n, Object object) {
            if ((n & 2) != 0) {
                consulOperations = companion.getConsulOperationsInFirstDc();
            }
            companion.deregisterService(string, consulOperations);
        }

        public final void deregisterServiceInRemoteDc(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.getConsulOperationsInSecondDc().deregisterService(id);
        }

        public final void deregisterAllServices() {
            this.getConsulOperationsInFirstDc().deregisterAll();
            this.getConsulOperationsInSecondDc().deregisterAll();
            this.getConsulAgentInDc1().getOperations().deregisterAll();
            Thread.sleep(1000L);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

