/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.envoy;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.Address;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.ClusterStatus;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.ClusterStatuses;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.HealthStatus;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.HostStatus;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.HttpResponseCloser;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.SocketAddress;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\f\u001a\u00020\u0003H\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0002J\b\u0010\f\u001a\u00020\u0003H\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u0003J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020!J\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0003J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010)\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyAdmin;", "", "address", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/String;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "client", "Lokhttp3/OkHttpClient;", "bootstrapConfigDump", "Lcom/fasterxml/jackson/databind/JsonNode;", "kotlin.jvm.PlatformType", "configDump", "circuitBreakerSetting", "", "cluster", "setting", "priority", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/ClusterStatus;", "name", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyAdmin$AdminInstance;", "ip", "clusters", "", "endpointsAddress", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/SocketAddress;", "clusterName", "get", "Lokhttp3/Response;", "path", "hostStatus", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/HostStatus;", "isEndpointHealthy", "", "isIngressReady", "nodeInfo", "numOfEndpoints", "post", "resetCounters", "", "statValue", "statName", "AdminInstance", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nEnvoyAdmin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvoyAdmin.kt\npl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyAdmin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n288#2,2:169\n1603#2,9:171\n1855#2:180\n1856#2:182\n1612#2:183\n1603#2,9:184\n1855#2:193\n1856#2:195\n1612#2:196\n1#3:181\n1#3:194\n1#3:197\n*S KotlinDebug\n*F\n+ 1 EnvoyAdmin.kt\npl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyAdmin\n*L\n25#1:169,2\n36#1:171,9\n36#1:180\n36#1:182\n36#1:183\n37#1:184,9\n37#1:193\n37#1:195\n37#1:196\n36#1:181\n37#1:194\n*E\n"})
public final class EnvoyAdmin {
    @NotNull
    private final String address;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final OkHttpClient client;

    public EnvoyAdmin(@NotNull String address, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.address = address;
        this.objectMapper = objectMapper;
        this.client = new OkHttpClient.Builder().build();
    }

    public /* synthetic */ EnvoyAdmin(String string, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ObjectMapper objectMapper2 = new ObjectMapper().registerModule((Module)new KotlinModule.Builder().build()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"configure(...)");
            objectMapper = objectMapper2;
        }
        this(string, objectMapper);
    }

    @Nullable
    public final ClusterStatus cluster(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.clusters();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ClusterStatus it = (ClusterStatus)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final int numOfEndpoints(@NotNull String clusterName) {
        List<HostStatus> list;
        Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
        ClusterStatus clusterStatus = this.cluster(clusterName);
        return clusterStatus != null && (list = clusterStatus.getHostStatuses()) != null ? list.size() : 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SocketAddress> endpointsAddress(@NotNull String clusterName) {
        List list;
        List<HostStatus> list2;
        Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
        ClusterStatus clusterStatus = this.cluster(clusterName);
        if (clusterStatus != null && (list2 = clusterStatus.getHostStatuses()) != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            Iterable iterable = list2;
            boolean $i$f$mapNotNull22 = false;
            void var6_7 = $this$mapNotNull$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Address it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                HostStatus it = (HostStatus)element$iv$iv;
                boolean bl2 = false;
                if (it.getAddress() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $i$f$mapNotNull22 = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                SocketAddress it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Address it = (Address)element$iv$iv;
                boolean bl4 = false;
                if (it.getSocketAddress() == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final HostStatus hostStatus(@NotNull String clusterName, @NotNull String ip) {
        HostStatus hostStatus;
        List<HostStatus> list;
        Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        ClusterStatus clusterStatus = this.cluster(clusterName);
        if (clusterStatus != null && (list = clusterStatus.getHostStatuses()) != null) {
            Object v1;
            block3: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    HostStatus it = (HostStatus)t;
                    boolean bl = false;
                    Object object = it.getAddress();
                    if (!Intrinsics.areEqual((Object)(object != null && (object = ((Address)object).getSocketAddress()) != null ? ((SocketAddress)object).getAddress() : null), (Object)ip)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            hostStatus = v1;
        } else {
            hostStatus = null;
        }
        return hostStatus;
    }

    public final boolean isEndpointHealthy(@NotNull String clusterName, @NotNull String ip) {
        HealthStatus healthStatus;
        Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        HostStatus hostStatus = this.hostStatus(clusterName, ip);
        return Intrinsics.areEqual(hostStatus != null && (healthStatus = hostStatus.getHealthStatus()) != null ? healthStatus.getEdsHealthStatus() : null, (Object)"HEALTHY");
    }

    public final boolean isIngressReady() {
        return !Intrinsics.areEqual((Object)this.statValue("http.ingress_http.rq_total"), (Object)"-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String statValue(@NotNull String statName) {
        Intrinsics.checkNotNullParameter((Object)statName, (String)"statName");
        ResponseBody responseBody = this.get("stats?filter=^" + statName + "$").body();
        if (responseBody != null) {
            Closeable closeable = (Closeable)responseBody;
            Throwable throwable = null;
            try {
                ResponseBody it = (ResponseBody)closeable;
                boolean bl = false;
                String[] stringArray = new String[]{":"};
                List splitedStats = StringsKt.split$default((CharSequence)((CharSequence)CollectionsKt.first((List)StringsKt.lines((CharSequence)it.string()))), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (splitedStats.size() != 2) {
                    String string = "-1";
                    return string;
                }
                String string = ((Object)StringsKt.trim((CharSequence)((String)splitedStats.get(1)))).toString();
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return null;
    }

    public final void resetCounters() {
        this.post("reset_counters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<ClusterStatus> clusters() {
        List<ClusterStatus> list;
        Response response2 = this.get("clusters?format=json");
        Closeable closeable = (Closeable)response2.body();
        Throwable throwable = null;
        try {
            ResponseBody it = (ResponseBody)closeable;
            boolean bl = false;
            ResponseBody responseBody = it;
            list = ((ClusterStatuses)this.objectMapper.readValue(responseBody != null ? responseBody.string() : null, ClusterStatuses.class)).getClusterStatuses();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String configDump() {
        String string;
        Response response2 = this.get("config_dump");
        Closeable closeable = (Closeable)response2.body();
        Throwable throwable = null;
        try {
            ResponseBody it = (ResponseBody)closeable;
            boolean bl = false;
            ResponseBody responseBody = it;
            Intrinsics.checkNotNull((Object)responseBody);
            string = responseBody.string();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    @NotNull
    public final String nodeInfo() {
        String configDump = this.configDump();
        JsonNode bootstrapConfigDump = this.bootstrapConfigDump(configDump);
        JsonNode node = bootstrapConfigDump.at("/bootstrap/node");
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ((ObjectNode)node).remove("hidden_envoy_deprecated_build_version");
        String string = this.objectMapper.writeValueAsString((Object)node);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    private final JsonNode bootstrapConfigDump(String configDump) {
        return this.objectMapper.readTree(configDump).at("/configs/0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final int circuitBreakerSetting(@NotNull String cluster, @NotNull String setting, @NotNull String priority) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
            Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            regex = new Regex(cluster + "::" + priority + "::" + setting + "::(.+)");
            response = this.get("clusters");
            var6_6 = response.body();
            if (var6_6 == null) ** GOTO lbl-1000
            var8_7 = (Closeable)var6_6;
            var9_8 = null;
            try {
                it = (ResponseBody)var8_7;
                $i$a$-use-EnvoyAdmin$circuitBreakerSetting$1 = false;
                it = StringsKt.lines((CharSequence)it.string());
            }
            catch (Throwable it) {
                var9_8 = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var8_7, (Throwable)var9_8);
            }
            var7_15 /* !! */  = it;
            if (var7_15 /* !! */  == null) ** GOTO lbl-1000
            it = (Iterable)var7_15 /* !! */ ;
            $i$a$-use-EnvoyAdmin$circuitBreakerSetting$1 = it.iterator();
            while ($i$a$-use-EnvoyAdmin$circuitBreakerSetting$1.hasNext()) {
                var12_16 = $i$a$-use-EnvoyAdmin$circuitBreakerSetting$1.next();
                it = (String)var12_16;
                $i$a$-find-EnvoyAdmin$circuitBreakerSetting$2 = false;
                if (!regex.matches((CharSequence)it)) continue;
                v0 = var12_16;
                break block9;
            }
            v0 = null;
        }
        var8_7 = v0;
        if (var8_7 != null) {
            it = var8_7;
            $i$a$-let-EnvoyAdmin$circuitBreakerSetting$3 = false;
            v1 = Regex.find$default((Regex)regex, (CharSequence)((CharSequence)it), (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)v1);
            v2 = Integer.parseInt((String)v1.getGroupValues().get(1));
        } else lbl-1000:
        // 3 sources

        {
            v2 = null;
        }
        Intrinsics.checkNotNull(v2);
        return v2;
    }

    public static /* synthetic */ int circuitBreakerSetting$default(EnvoyAdmin envoyAdmin, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "default_priority";
        }
        return envoyAdmin.circuitBreakerSetting(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final AdminInstance cluster(@NotNull String cluster, @NotNull String ip) {
        Object v0;
        Object it2;
        Object object;
        Regex regex;
        block7: {
            Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            regex = new Regex(cluster + "::" + ip + ":5678::zone::(.+)");
            Response response2 = this.get("clusters");
            ResponseBody responseBody = response2.body();
            if (responseBody == null) return null;
            object = (Closeable)responseBody;
            Throwable throwable = null;
            try {
                it2 = (ResponseBody)object;
                boolean bl = false;
                it2 = StringsKt.lines((CharSequence)it2.string());
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Object object2 = it2;
            if (object2 == null) return null;
            it2 = (Iterable)object2;
            Iterator bl = it2.iterator();
            while (bl.hasNext()) {
                Object t = bl.next();
                String it3 = (String)t;
                boolean bl2 = false;
                if (!regex.matches((CharSequence)it3)) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        object = v0;
        if (object == null) return null;
        it2 = object;
        boolean bl = false;
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)((CharSequence)it2), (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        AdminInstance adminInstance = new AdminInstance(ip, (String)matchResult.getGroupValues().get(1));
        return adminInstance;
    }

    private final Response get(String path) {
        return HttpResponseCloser.INSTANCE.addToCloseableResponses(this.client.newCall(new Request.Builder().get().url(this.address + "/" + path).build()).execute());
    }

    private final Response post(String path) {
        return HttpResponseCloser.INSTANCE.addToCloseableResponses(this.client.newCall(new Request.Builder().post(RequestBody.Companion.create(MediaType.Companion.get("application/json"), "{}")).url(this.address + "/" + path).build()).execute());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyAdmin$AdminInstance;", "", "ip", "", "cluster", "(Ljava/lang/String;Ljava/lang/String;)V", "getCluster", "()Ljava/lang/String;", "getIp", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "envoy-control-tests"})
    public static final class AdminInstance {
        @NotNull
        private final String ip;
        @NotNull
        private final String cluster;

        public AdminInstance(@NotNull String ip, @NotNull String cluster) {
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
            this.ip = ip;
            this.cluster = cluster;
        }

        @NotNull
        public final String getIp() {
            return this.ip;
        }

        @NotNull
        public final String getCluster() {
            return this.cluster;
        }

        @NotNull
        public final String component1() {
            return this.ip;
        }

        @NotNull
        public final String component2() {
            return this.cluster;
        }

        @NotNull
        public final AdminInstance copy(@NotNull String ip, @NotNull String cluster) {
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
            return new AdminInstance(ip, cluster);
        }

        public static /* synthetic */ AdminInstance copy$default(AdminInstance adminInstance, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = adminInstance.ip;
            }
            if ((n & 2) != 0) {
                string2 = adminInstance.cluster;
            }
            return adminInstance.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "AdminInstance(ip=" + this.ip + ", cluster=" + this.cluster + ")";
        }

        public int hashCode() {
            int result = this.ip.hashCode();
            result = result * 31 + this.cluster.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AdminInstance)) {
                return false;
            }
            AdminInstance adminInstance = (AdminInstance)other;
            if (!Intrinsics.areEqual((Object)this.ip, (Object)adminInstance.ip)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cluster, (Object)adminInstance.cluster);
        }
    }
}

