/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.Closeable;
import java.time.Duration;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.http.HttpStatus;
import pl.allegro.tech.servicemesh.envoycontrol.EnvoyControl;
import pl.allegro.tech.servicemesh.envoycontrol.LoggerKt;
import pl.allegro.tech.servicemesh.envoycontrol.chaos.api.NetworkDelay;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.HttpResponseCloser;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlTestApp;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.Health;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.SnapshotDebugResponse;
import pl.allegro.tech.servicemesh.envoycontrol.services.ServicesState;
import pl.allegro.tech.servicemesh.envoycontrol.utils.Ports;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 72\u00020\u0001:\u0003789BG\u0012\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0016J\b\u0010!\u001a\u00020\u001dH\u0002J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\u0017\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0005H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020&H\u0016J\b\u0010/\u001a\u000200H\u0016J \u00101\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000205H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006:"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlRunnerTestApp;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlTestApp;", "propertiesProvider", "Lkotlin/Function0;", "", "", "", "consulPort", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "grpcPort", "appPort", "(Lkotlin/jvm/functions/Function0;ILcom/fasterxml/jackson/databind/ObjectMapper;II)V", "app", "Lorg/springframework/boot/builder/SpringApplicationBuilder;", "appName", "getAppName", "()Ljava/lang/String;", "getAppPort", "()I", "baseProperties", "getConsulPort", "getGrpcPort", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getPropertiesProvider", "()Lkotlin/jvm/functions/Function0;", "deleteChaosFaultRequest", "Lokhttp3/Response;", "username", "password", "faultId", "getApplicationStatusResponse", "getExperimentsListRequest", "getGlobalSnapshot", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/SnapshotDebugResponse;", "xds", "", "(Ljava/lang/Boolean;)Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/SnapshotDebugResponse;", "getHealthStatus", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/Health;", "getSnapshot", "nodeJson", "getState", "Lpl/allegro/tech/servicemesh/envoycontrol/services/ServicesState;", "isHealthy", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "postChaosFaultRequest", "networkDelay", "Lpl/allegro/tech/servicemesh/envoycontrol/chaos/api/NetworkDelay;", "run", "", "stop", "Companion", "SnapshotDebugResponseInvalidStatusException", "SnapshotDebugResponseMissingException", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nEnvoyControlTestApp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvoyControlTestApp.kt\npl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlRunnerTestApp\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class EnvoyControlRunnerTestApp
implements EnvoyControlTestApp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Map<String, Object>> propertiesProvider;
    private final int consulPort;
    @NotNull
    private final ObjectMapper objectMapper;
    private final int grpcPort;
    private final int appPort;
    @NotNull
    private final String appName;
    private SpringApplicationBuilder app;
    @NotNull
    private final Map<String, Object> baseProperties;
    @NotNull
    private static final Lazy<Logger> logger$delegate = LoggerKt.logger((Object)Companion);
    @NotNull
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().build();

    public EnvoyControlRunnerTestApp(@NotNull Function0<? extends Map<String, ? extends Object>> propertiesProvider, int consulPort, @NotNull ObjectMapper objectMapper, int grpcPort, int appPort) {
        Intrinsics.checkNotNullParameter(propertiesProvider, (String)"propertiesProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.propertiesProvider = propertiesProvider;
        this.consulPort = consulPort;
        this.objectMapper = objectMapper;
        this.grpcPort = grpcPort;
        this.appPort = appPort;
        this.appName = "envoy-control";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"spring.profiles.active", (Object)"test"), TuplesKt.to((Object)"spring.jmx.enabled", (Object)false), TuplesKt.to((Object)"envoy-control.source.consul.port", (Object)this.consulPort), TuplesKt.to((Object)"envoy-control.envoy.snapshot.outgoing-permissions.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.sync.polling-interval", (Object)Duration.ofSeconds(1L).getSeconds()), TuplesKt.to((Object)"envoy-control.server.port", (Object)this.getGrpcPort()), TuplesKt.to((Object)"envoy-control.envoy.snapshot.load-balancing.policy", (Object)"ROUND_ROBIN")};
        this.baseProperties = MapsKt.mapOf((Pair[])pairArray);
    }

    public /* synthetic */ EnvoyControlRunnerTestApp(Function0 function0, int n, ObjectMapper objectMapper, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n4 & 4) != 0) {
            ObjectMapper objectMapper2 = new ObjectMapper().registerModule((Module)new KotlinModule.Builder().build()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"configure(...)");
            objectMapper = objectMapper2;
        }
        if ((n4 & 8) != 0) {
            n2 = Ports.INSTANCE.nextAvailable();
        }
        if ((n4 & 0x10) != 0) {
            n3 = Ports.INSTANCE.nextAvailable();
        }
        this((Function0<? extends Map<String, ? extends Object>>)function0, n, objectMapper, n2, n3);
    }

    @NotNull
    public final Function0<Map<String, Object>> getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public final int getConsulPort() {
        return this.consulPort;
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public int getGrpcPort() {
        return this.grpcPort;
    }

    @Override
    public int getAppPort() {
        return this.appPort;
    }

    @Override
    @NotNull
    public String getAppName() {
        return this.appName;
    }

    @Override
    public void run() {
        Class[] classArray = new Class[]{EnvoyControl.class};
        SpringApplicationBuilder springApplicationBuilder = new SpringApplicationBuilder(classArray).properties(MapsKt.plus(this.baseProperties, (Map)((Map)this.propertiesProvider.invoke())));
        Intrinsics.checkNotNullExpressionValue((Object)springApplicationBuilder, (String)"properties(...)");
        this.app = springApplicationBuilder;
        SpringApplicationBuilder springApplicationBuilder2 = this.app;
        if (springApplicationBuilder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            springApplicationBuilder2 = null;
        }
        String[] stringArray = new String[]{"--server.port=" + this.getAppPort(), "-e test"};
        springApplicationBuilder2.run(stringArray);
        Companion.getLogger().info("starting EC on port " + this.getAppPort() + ", grpc: " + this.getGrpcPort() + ", consul: " + this.consulPort);
    }

    @Override
    public void stop() {
        SpringApplicationBuilder springApplicationBuilder = this.app;
        if (springApplicationBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            springApplicationBuilder = null;
        }
        springApplicationBuilder.context().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHealthy() {
        boolean bl;
        Closeable closeable = (Closeable)this.getApplicationStatusResponse();
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl2 = false;
            bl = it.isSuccessful();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Health getHealthStatus() {
        String string;
        Response response2 = this.getApplicationStatusResponse();
        ObjectMapper objectMapper = this.objectMapper;
        ResponseBody responseBody = response2.body();
        if (responseBody != null) {
            String string2;
            Closeable closeable = (Closeable)responseBody;
            ObjectMapper objectMapper2 = objectMapper;
            Throwable throwable = null;
            try {
                ResponseBody it = (ResponseBody)closeable;
                boolean bl = false;
                string2 = it.string();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            string = string2;
            objectMapper = objectMapper2;
        } else {
            string = null;
        }
        Object object = objectMapper.readValue(string, Health.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (Health)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ServicesState getState() {
        String string;
        Response response2 = HttpResponseCloser.INSTANCE.addToCloseableResponses(httpClient.newCall(new Request.Builder().get().url("http://localhost:" + this.getAppPort() + "/state").build()).execute());
        ObjectMapper objectMapper = this.objectMapper;
        ResponseBody responseBody = response2.body();
        if (responseBody != null) {
            String string2;
            Closeable closeable = (Closeable)responseBody;
            ObjectMapper objectMapper2 = objectMapper;
            Throwable throwable = null;
            try {
                ResponseBody it = (ResponseBody)closeable;
                boolean bl = false;
                string2 = it.string();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            string = string2;
            objectMapper = objectMapper2;
        } else {
            string = null;
        }
        Object object = objectMapper.readValue(string, ServicesState.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (ServicesState)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SnapshotDebugResponse getSnapshot(@NotNull String nodeJson) {
        Object object;
        block12: {
            block11: {
                SnapshotDebugResponse snapshotDebugResponse;
                Intrinsics.checkNotNullParameter((Object)nodeJson, (String)"nodeJson");
                Response response2 = HttpResponseCloser.INSTANCE.addToCloseableResponses(httpClient.newCall(new Request.Builder().addHeader("Accept", "application/v3+json").post(RequestBody.Companion.create(MediaType.Companion.get("application/json"), nodeJson)).url("http://localhost:" + this.getAppPort() + "/snapshot").build()).execute());
                if (response2.code() == HttpStatus.NOT_FOUND.value()) {
                    return new SnapshotDebugResponse(false, null, null, 6, null);
                }
                if (!response2.isSuccessful()) {
                    throw new SnapshotDebugResponseInvalidStatusException(response2.code());
                }
                ResponseBody responseBody = response2.body();
                if (responseBody == null) break block11;
                object = (Closeable)responseBody;
                Throwable throwable = null;
                try {
                    ResponseBody it = (ResponseBody)object;
                    boolean bl = false;
                    snapshotDebugResponse = (SnapshotDebugResponse)this.objectMapper.readValue(it.byteStream(), SnapshotDebugResponse.class);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                SnapshotDebugResponse snapshotDebugResponse2 = snapshotDebugResponse;
                if (snapshotDebugResponse2 != null && (object = SnapshotDebugResponse.copy$default(snapshotDebugResponse2, true, null, null, 6, null)) != null) break block12;
            }
            throw new SnapshotDebugResponseMissingException();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SnapshotDebugResponse getGlobalSnapshot(@Nullable Boolean xds) {
        Object object;
        block13: {
            block12: {
                SnapshotDebugResponse snapshotDebugResponse;
                Response response2;
                String url = "http://localhost:" + this.getAppPort() + "/snapshot-global";
                if (xds != null) {
                    url = url + "?xds=" + xds;
                }
                if ((response2 = HttpResponseCloser.INSTANCE.addToCloseableResponses(httpClient.newCall(new Request.Builder().get().url(url).build()).execute())).code() == HttpStatus.NOT_FOUND.value()) {
                    return new SnapshotDebugResponse(false, null, null, 6, null);
                }
                if (!response2.isSuccessful()) {
                    throw new SnapshotDebugResponseInvalidStatusException(response2.code());
                }
                ResponseBody responseBody = response2.body();
                if (responseBody == null) break block12;
                object = (Closeable)responseBody;
                Throwable throwable = null;
                try {
                    ResponseBody it = (ResponseBody)object;
                    boolean bl = false;
                    snapshotDebugResponse = (SnapshotDebugResponse)this.objectMapper.readValue(it.byteStream(), SnapshotDebugResponse.class);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                SnapshotDebugResponse snapshotDebugResponse2 = snapshotDebugResponse;
                if (snapshotDebugResponse2 != null && (object = SnapshotDebugResponse.copy$default(snapshotDebugResponse2, true, null, null, 6, null)) != null) break block13;
            }
            throw new SnapshotDebugResponseMissingException();
        }
        return object;
    }

    private final Response getApplicationStatusResponse() {
        return HttpResponseCloser.INSTANCE.addToCloseableResponses(httpClient.newCall(new Request.Builder().get().url("http://localhost:" + this.getAppPort() + "/actuator/health").build()).execute());
    }

    @Override
    @NotNull
    public Response postChaosFaultRequest(@NotNull String username, @NotNull String password, @NotNull NetworkDelay networkDelay) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)networkDelay, (String)"networkDelay");
        String credentials = Credentials.basic$default((String)username, (String)password, null, (int)4, null);
        String request2 = this.objectMapper.writeValueAsString((Object)networkDelay);
        MediaType mediaType = MediaType.Companion.get("application/json");
        Intrinsics.checkNotNull((Object)request2);
        RequestBody requestBody = RequestBody.Companion.create(mediaType, request2);
        return HttpResponseCloser.INSTANCE.addToCloseableResponses(httpClient.newCall(new Request.Builder().header("Authorization", credentials).post(requestBody).url("http://localhost:" + this.getAppPort() + "/chaos/fault/read-network-delay").build()).execute());
    }

    @Override
    @NotNull
    public Response getExperimentsListRequest(@NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String credentials = Credentials.basic$default((String)username, (String)password, null, (int)4, null);
        return HttpResponseCloser.INSTANCE.addToCloseableResponses(httpClient.newCall(new Request.Builder().header("Authorization", credentials).get().url("http://localhost:" + this.getAppPort() + "/chaos/fault/read-network-delay").build()).execute());
    }

    @Override
    @NotNull
    public Response deleteChaosFaultRequest(@NotNull String username, @NotNull String password, @NotNull String faultId) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)faultId, (String)"faultId");
        String credentials = Credentials.basic$default((String)username, (String)password, null, (int)4, null);
        return HttpResponseCloser.INSTANCE.addToCloseableResponses(httpClient.newCall(Request.Builder.delete$default((Request.Builder)new Request.Builder().header("Authorization", credentials), null, (int)1, null).url("http://localhost:" + this.getAppPort() + "/chaos/fault/read-network-delay/" + faultId).build()).execute());
    }

    @Override
    @NotNull
    public MeterRegistry meterRegistry() {
        SpringApplicationBuilder springApplicationBuilder = this.app;
        if (springApplicationBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            springApplicationBuilder = null;
        }
        Object object = springApplicationBuilder.context().getBean(MeterRegistry.class);
        if (object == null) {
            boolean bl = false;
            String string = "MeterRegistry bean not found in the context";
            throw new IllegalStateException(string.toString());
        }
        return (MeterRegistry)object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlRunnerTestApp$Companion;", "", "()V", "httpClient", "Lokhttp3/OkHttpClient;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            Lazy lazy = logger$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlRunnerTestApp$SnapshotDebugResponseInvalidStatusException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "status", "", "(I)V", "envoy-control-tests"})
    public static final class SnapshotDebugResponseInvalidStatusException
    extends RuntimeException {
        public SnapshotDebugResponseInvalidStatusException(int status) {
            super("Invalid snapshot debug response status: " + status);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlRunnerTestApp$SnapshotDebugResponseMissingException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "()V", "envoy-control-tests"})
    public static final class SnapshotDebugResponseMissingException
    extends RuntimeException {
        public SnapshotDebugResponseMissingException() {
            super("Expected snapshot debug in response body but got none");
        }
    }
}

