/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.sharing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.testcontainers.lifecycle.Startables;
import pl.allegro.tech.servicemesh.envoycontrol.LoggerKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.sharing.BeforeAndAfterAllOnce;
import pl.allegro.tech.servicemesh.envoycontrol.config.sharing.ContainerExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers.GenericContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J!\u0010\f\u001a\u00020\b2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u000e\u00a2\u0006\u0002\b\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u0011\u001a\u00020\bH\u0014R\u0016\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/BeforeAndAfterAllOnce;", "()V", "container", "Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer;", "getContainer", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer;", "afterAllOnce", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "beforeAllOnce", "logAndThrowError", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "preconditions", "waitUntilHealthy", "Companion", "Parallel", "envoy-control-tests"})
public abstract class ContainerExtension
implements BeforeAndAfterAllOnce {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Logger> logger$delegate = LoggerKt.logger((Object)Companion);

    @NotNull
    public abstract GenericContainer<?> getContainer();

    protected void preconditions(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    protected void waitUntilHealthy() {
    }

    @Override
    public void beforeAllOnce(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.preconditions(context);
        this.logAndThrowError((Function1<? super ContainerExtension, Unit>)((Function1)beforeAllOnce.1.INSTANCE));
    }

    @Override
    public void afterAllOnce(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.getContainer().stop();
    }

    private final void logAndThrowError(Function1<? super ContainerExtension, Unit> action) {
        try {
            action.invoke((Object)this);
        }
        catch (Exception e) {
            Companion.getLogger().error("Logs from failed container: " + this.getContainer().getLogs(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void beforeAll(@NotNull ExtensionContext context) {
        BeforeAndAfterAllOnce.DefaultImpls.beforeAll(this, context);
    }

    @Override
    public void afterAll(@NotNull ExtensionContext context) {
        BeforeAndAfterAllOnce.DefaultImpls.afterAll(this, context);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            Lazy lazy = logger$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0010"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension$Parallel;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/BeforeAndAfterAllOnce;", "extensions", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension;", "([Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension;)V", "ctx", "Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/BeforeAndAfterAllOnce$Context;", "getCtx", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/BeforeAndAfterAllOnce$Context;", "[Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension;", "afterAllOnce", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "beforeAllOnce", "envoy-control-tests"})
    @SourceDebugExtension(value={"SMAP\nContainerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerExtension.kt\npl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension$Parallel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,58:1\n13309#2,2:59\n11065#2:61\n11400#2,3:62\n13309#2,2:65\n13309#2,2:67\n*S KotlinDebug\n*F\n+ 1 ContainerExtension.kt\npl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension$Parallel\n*L\n38#1:59,2\n42#1:61\n42#1:62,3\n46#1:65,2\n52#1:67,2\n*E\n"})
    public static final class Parallel
    implements BeforeAndAfterAllOnce {
        @NotNull
        private final ContainerExtension[] extensions;
        @NotNull
        private final BeforeAndAfterAllOnce.Context ctx;

        public Parallel(ContainerExtension ... extensions) {
            Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
            this.extensions = extensions;
            this.ctx = new BeforeAndAfterAllOnce.Context(null, false, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void beforeAllOnce(@NotNull ExtensionContext context) {
            int n;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ContainerExtension[] $this$forEach$iv = this.extensions;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int i = 0; i < n2; ++i) {
                ContainerExtension element$iv;
                ContainerExtension extension = element$iv = $this$forEach$iv[i];
                n = 0;
                extension.logAndThrowError((Function1<? super ContainerExtension, Unit>)((Function1)new Function1<ContainerExtension, Unit>(context){
                    final /* synthetic */ ExtensionContext $context;
                    {
                        this.$context = $context;
                        super(1);
                    }

                    public final void invoke(@NotNull ContainerExtension $this$logAndThrowError) {
                        Intrinsics.checkNotNullParameter((Object)$this$logAndThrowError, (String)"$this$logAndThrowError");
                        $this$logAndThrowError.preconditions(this.$context);
                    }
                }));
            }
            try {
                void $this$mapTo$iv$iv;
                ContainerExtension[] $this$map$iv = this.extensions;
                boolean $i$f$map = false;
                ContainerExtension[] containerExtensionArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                n = ((void)$this$mapTo$iv$iv).length;
                for (int extension = 0; extension < n; ++extension) {
                    void it;
                    void item$iv$iv;
                    void var10_19 = item$iv$iv = $this$mapTo$iv$iv[extension];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getContainer());
                }
                Startables.deepStart((Collection)((List)destination$iv$iv)).join();
            }
            catch (Exception e) {
                Companion.getLogger().error("Starting containers in parallel failed", (Throwable)e);
            }
            $this$forEach$iv = this.extensions;
            $i$f$forEach = false;
            int n3 = $this$forEach$iv.length;
            for (int i = 0; i < n3; ++i) {
                ContainerExtension element$iv;
                ContainerExtension extension = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                extension.logAndThrowError((Function1<? super ContainerExtension, Unit>)beforeAllOnce.3.1.INSTANCE);
            }
        }

        @Override
        public void afterAllOnce(@NotNull ExtensionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ContainerExtension[] $this$forEach$iv = this.extensions;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                ContainerExtension element$iv;
                ContainerExtension extension = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                extension.afterAll(context);
            }
        }

        @Override
        @NotNull
        public BeforeAndAfterAllOnce.Context getCtx() {
            return this.ctx;
        }

        @Override
        public void beforeAll(@NotNull ExtensionContext context) {
            BeforeAndAfterAllOnce.DefaultImpls.beforeAll(this, context);
        }

        @Override
        public void afterAll(@NotNull ExtensionContext context) {
            BeforeAndAfterAllOnce.DefaultImpls.afterAll(this, context);
        }
    }
}

