/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.sharing;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.GenericContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\f\b\u0001\u0010\u0002*\u0006\u0012\u0002\b\u00030\u00032\u00020\u0004:\u0001\u0012B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00028\u00012\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerPool;", "OWNER", "CONTAINER", "Lorg/testcontainers/containers/GenericContainer;", "", "containerFactory", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "freeContainers", "Ljava/util/Queue;", "usedContainers", "", "acquire", "owner", "(Ljava/lang/Object;)Lorg/testcontainers/containers/GenericContainer;", "release", "", "(Ljava/lang/Object;)V", "ContainerNotFound", "envoy-control-tests"})
public final class ContainerPool<OWNER, CONTAINER extends GenericContainer<?>> {
    @NotNull
    private final Function0<CONTAINER> containerFactory;
    @NotNull
    private final Queue<CONTAINER> freeContainers;
    @NotNull
    private final Map<OWNER, CONTAINER> usedContainers;

    public ContainerPool(@NotNull Function0<? extends CONTAINER> containerFactory) {
        Intrinsics.checkNotNullParameter(containerFactory, (String)"containerFactory");
        this.containerFactory = containerFactory;
        this.freeContainers = new LinkedList();
        this.usedContainers = new LinkedHashMap();
    }

    @NotNull
    public final CONTAINER acquire(OWNER owner) {
        GenericContainer genericContainer = (GenericContainer)this.freeContainers.poll();
        if (genericContainer == null) {
            genericContainer = (GenericContainer)this.containerFactory.invoke();
        }
        GenericContainer container2 = genericContainer;
        container2.start();
        this.usedContainers.put(owner, container2);
        return (CONTAINER)container2;
    }

    public final void release(OWNER owner) {
        GenericContainer genericContainer = (GenericContainer)this.usedContainers.remove(owner);
        if (genericContainer == null) {
            throw new ContainerNotFound(String.valueOf(owner));
        }
        GenericContainer container2 = genericContainer;
        this.freeContainers.add(container2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerPool$ContainerNotFound;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "owner", "", "(Ljava/lang/String;)V", "envoy-control-tests"})
    public static final class ContainerNotFound
    extends RuntimeException {
        public ContainerNotFound(@NotNull String owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super("container owned by " + owner + " not found");
        }
    }
}

