/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.testcontainers.junit.jupiter.Testcontainers;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.EnvoyAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulMultiClusterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.containers.ProxyOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.containers.ToxiproxyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.IngressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlClusteredExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.permissions.IncomingPermissionsLoggingModeTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Testcontainers
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007J\b\u0010\u0012\u001a\u00020\u0004H\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0007J\b\u0010\u0014\u001a\u00020\u0004H\u0007J\b\u0010\u0015\u001a\u00020\u0004H\u0007J\b\u0010\u0016\u001a\u00020\u0004H\u0007J\b\u0010\u0017\u001a\u00020\u0004H\u0007J\b\u0010\u0018\u001a\u00020\u0004H\u0007J\b\u0010\u0019\u001a\u00020\u0004H\u0007J\b\u0010\u001a\u001a\u00020\u0004H\u0007J\b\u0010\u001b\u001a\u00020\u0004H\u0007J\b\u0010\u001c\u001a\u00020\u0004H\u0007J\b\u0010\u001d\u001a\u00020\u0004H\u0007J\b\u0010\u001e\u001a\u00020\u0004H\u0007J\b\u0010\u001f\u001a\u00020\u0004H\u0007J\b\u0010 \u001a\u00020\u0004H\u0007J\b\u0010!\u001a\u00020\u0004H\u0007J\b\u0010\"\u001a\u00020\u0004H\u0007J\b\u0010#\u001a\u00020\u0004H\u0007J\b\u0010$\u001a\u00020\u0004H\u0007J\b\u0010%\u001a\u00020\u0004H\u0007J\b\u0010&\u001a\u00020\u0004H\u0007J$\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020)0-J\b\u0010.\u001a\u00020\u0004H\u0007J\b\u0010/\u001a\u00020\u0004H\u0007J\b\u00100\u001a\u00020\u0004H\u0002\u00a8\u00062"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsLoggingModeTest;", "", "()V", "cleanupTest", "", "echo should NOT allow echo2 to access 'block-unlisted-clients' endpoint over https", "echo should NOT allow echo2 to access 'block-unlisted-clients-by-default' endpoint over https", "echo should NOT allow echo2 to access unlisted endpoint over https", "echo should NOT allow echo3 to access 'log-unlisted-clients' endpoint with wrong http method", "echo should NOT allow echo3 to access unlisted endpoint over https", "echo should NOT allow source-ip-client to access unlisted endpoint over http", "echo should NOT allow unlisted clients to access 'block-unlisted-clients-by-default' endpoint over http", "echo should NOT allow unlisted clients to access unlisted endpoint over http", "echo should allow access to status endpoint by all clients over http", "echo should allow echo2 to access 'log-unlisted-clients' endpoint over https and log it", "echo should allow echo3 to access 'block-unlisted-clients' endpoint over https", "echo should allow echo3 to access 'block-unlisted-clients-by-default' endpoint over https", "echo should allow echo3 to access 'log-unlisted-clients' endpoint over https", "echo should allow source-ip-client to access 'block-unlisted-clients-by-default' endpoint over http", "echo should allow source-ip-client to access 'log-unlisted-clients' endpoint over http", "echo should allow unlisted clients to access 'log-unlisted-clients' endpoint over http and log it", "echo2 should NOT allow echo to access 'block-unlisted-clients' endpoint over https", "echo2 should NOT allow echo to access 'block-unlisted-clients-by-default' endpoint over https", "echo2 should NOT allow unlisted clients to access 'block-unlisted-clients' endpoint over http", "echo2 should NOT allow unlisted clients to access 'block-unlisted-clients-by-default' endpoint over http", "echo2 should allow access to status endpoint by any client over http", "echo2 should allow echo to access 'log-unlisted-clients' endpoint over https and log it", "echo2 should allow echo to access unlisted endpoint over https and log it", "echo2 should allow echo3 to access 'block-unlisted-clients' endpoint over https", "echo2 should allow echo3 to access 'block-unlisted-clients-by-default' endpoint over https", "echo2 should allow echo3 to access 'log-unlisted-clients' endpoint over https", "echo2 should allow echo3 to access 'log-unlisted-clients' endpoint with wrong http method and log it", "echo2 should allow echo3 to access unlisted endpoint over https and log it", "echo2 should allow source-ip-client to access 'block-unlisted-clients-by-default' endpoint over http", "echo2 should allow source-ip-client to access 'log-unlisted-clients' endpoint over http", "echo2 should allow source-ip-client to access unlisted endpoint over http", "echo2 should allow unlisted client with client identity header over https and log client name as untrusted", "echo2 should allow unlisted clients to access 'log-unlisted-clients' endpoint over http and log it", "echo2 should allow unlisted clients to access unlisted endpoint over http", "registerServiceWithEnvoyOnIngress", "name", "", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "tags", "", "should allow echo3 to access status endpoint over https", "startRecordingRBACLogs", "waitForEnvoysInitialized", "Companion", "envoy-control-tests"})
public final class IncomingPermissionsLoggingModeTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String prefix = "envoy-control.envoy.snapshot";
    @NotNull
    private static final Function1<String, Map<String, Object>> properties = Companion.properties.1.INSTANCE;
    @NotNull
    private static final String echo3Config = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"echo\"\n          - service: \"echo2\"";
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ToxiproxyExtension sourceIpClient = new ToxiproxyExtension(2);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulMultiClusterExtension consul = new ConsulMultiClusterExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoLocalService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echo2LocalService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension localService;
    @NotNull
    private static final EnvoyConfig echoConfig;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echoEnvoy;
    @NotNull
    private static final EnvoyConfig echo2Config;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echo2Envoy;
    @NotNull
    private static final EnvoyConfig echo3EnvoyConfig;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echo3Envoy;
    @NotNull
    private static final Lazy<ProxyOperations> sourceIpClientToEchoProxy$delegate;
    @NotNull
    private static final Lazy<ProxyOperations> sourceIpClientToEcho2Proxy$delegate;

    @BeforeEach
    public final void startRecordingRBACLogs() {
        this.registerServiceWithEnvoyOnIngress("echo", echoEnvoy, CollectionsKt.listOf((Object)"mtls:enabled"));
        this.registerServiceWithEnvoyOnIngress("echo2", echo2Envoy, CollectionsKt.listOf((Object)"mtls:enabled"));
        this.waitForEnvoysInitialized();
        echoEnvoy.recordRBACLogs();
        echo2Envoy.recordRBACLogs();
    }

    @AfterEach
    public final void cleanupTest() {
        echoEnvoy.stopRecordingRBAC();
        echo2Envoy.stopRecordingRBAC();
    }

    public final void registerServiceWithEnvoyOnIngress(@NotNull String name, @NotNull EnvoyExtension envoy, @NotNull List<String> tags) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        ConsulOperations.registerService$default(consul.getServerFirst().getOperations(), id, name, envoy.getContainer().ipAddress(), 5001, false, tags, null, 80, null);
    }

    private final void waitForEnvoysInitialized() {
        AwaitAssertionsKt.untilAsserted$default(null, null, waitForEnvoysInitialized.1.INSTANCE, 3, null);
    }

    @Test
    public final void should allow echo3 to access status endpoint over https() {
        Response echoResponse = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo", null, "/status/hc", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoLocalService);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
        Response echo2Response = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo2", null, "/status/hc", null, null, 26, null);
        ObjectAssert objectAssert3 = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert3, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert3), echo2LocalService);
        String string2 = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null)).isOne();
        ObjectAssert objectAssert4 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert4, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert4);
    }

    @Test
    public final void echo should allow access to status endpoint by all clients over http() {
        Response echoResponse = IngressOperations.callLocalService$default(echoEnvoy.getIngressOperations(), "/status/hc", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoLocalService);
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void echo2 should allow access to status endpoint by any client over http() {
        Response echo2Response = IngressOperations.callLocalService$default(echo2Envoy.getIngressOperations(), "/status/hc", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void echo should allow echo3 to access 'block-unlisted-clients' endpoint over https() {
        Response echoResponse = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo", null, "/block-unlisted-clients", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoLocalService);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void echo2 should allow echo3 to access 'block-unlisted-clients' endpoint over https() {
        Response echoResponse2 = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo2", null, "/block-unlisted-clients", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void echo should NOT allow echo2 to access 'block-unlisted-clients' endpoint over https() {
        Response echoResponse = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/block-unlisted-clients", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "https", "/block-unlisted-clients", "GET", "echo2", true, "echo", echo2Envoy.getContainer().ipAddress(), false, 128, null);
    }

    @Test
    public final void echo2 should NOT allow echo to access 'block-unlisted-clients' endpoint over https() {
        Response echo2Response = EgressOperations.callService$default(echoEnvoy.getEgressOperations(), "echo2", null, "/block-unlisted-clients", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        String string2 = echoEnvoy.getContainer().ipAddress();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "https", "/block-unlisted-clients", "GET", "echo", true, "echo2", string2, false, 128, null);
    }

    @Test
    public final void echo should allow source-ip-client to access 'block-unlisted-clients-by-default' endpoint over http() {
        Response echoResponse = Companion.getSourceIpClientToEchoProxy().call("/block-unlisted-clients-by-default");
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoLocalService);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void echo2 should allow source-ip-client to access 'block-unlisted-clients-by-default' endpoint over http() {
        Response echo2Response = Companion.getSourceIpClientToEcho2Proxy().call("/block-unlisted-clients-by-default");
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void echo should NOT allow unlisted clients to access 'block-unlisted-clients-by-default' endpoint over http() {
        Response echoResponse = IngressOperations.callLocalService$default(echoEnvoy.getIngressOperations(), "/block-unlisted-clients-by-default", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        String string2 = echoEnvoy.getContainer().ingressHost();
        String string3 = echoEnvoy.getContainer().gatewayIp();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "http", "/block-unlisted-clients-by-default", "GET", "", false, string2, string3, false, 128, null);
    }

    @Test
    public final void echo2 should NOT allow unlisted clients to access 'block-unlisted-clients' endpoint over http() {
        Response echo2Response = IngressOperations.callLocalService$default(echo2Envoy.getIngressOperations(), "/block-unlisted-clients", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        String string2 = echo2Envoy.getContainer().ingressHost();
        String string3 = echo2Envoy.getContainer().gatewayIp();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "http", "/block-unlisted-clients", "GET", "", false, string2, string3, false, 128, null);
    }

    @Test
    public final void echo should allow echo3 to access 'log-unlisted-clients' endpoint over https() {
        Response echoResponse = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo", null, "/log-unlisted-clients", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoLocalService);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    @Tag(value="flaky")
    public final void echo2 should allow echo3 to access 'log-unlisted-clients' endpoint over https() {
        Response echo2Response = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo2", null, "/log-unlisted-clients", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void echo should allow echo2 to access 'log-unlisted-clients' endpoint over https and log it() {
        Response echoResponse = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/log-unlisted-clients", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoLocalService);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        String string2 = echo2Envoy.getContainer().ipAddress();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "https", "/log-unlisted-clients", "GET", "echo2", true, "echo", null, string2, null, 320, null);
    }

    @Test
    public final void echo2 should allow echo to access 'log-unlisted-clients' endpoint over https and log it() {
        Response echo2Response = EgressOperations.callService$default(echoEnvoy.getEgressOperations(), "echo2", null, "/log-unlisted-clients", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "https", "/log-unlisted-clients", "GET", "echo", null, null, null, echoEnvoy.getContainer().ipAddress(), null, 368, null);
    }

    @Test
    public final void echo should allow source-ip-client to access 'log-unlisted-clients' endpoint over http() {
        Response echoResponse = Companion.getSourceIpClientToEchoProxy().call("/log-unlisted-clients");
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoLocalService);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void echo2 should allow source-ip-client to access 'log-unlisted-clients' endpoint over http() {
        Response echo2Response = Companion.getSourceIpClientToEcho2Proxy().call("/log-unlisted-clients");
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void echo should allow unlisted clients to access 'log-unlisted-clients' endpoint over http and log it() {
        Response echoResponse = IngressOperations.callLocalService$default(echoEnvoy.getIngressOperations(), "/log-unlisted-clients", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoLocalService);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "http", "/log-unlisted-clients", "GET", "", null, null, null, echoEnvoy.getContainer().gatewayIp(), null, 368, null);
    }

    @Test
    public final void echo2 should allow unlisted clients to access 'log-unlisted-clients' endpoint over http and log it() {
        Response echo2Response = IngressOperations.callLocalService$default(echo2Envoy.getIngressOperations(), "/log-unlisted-clients", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "http", "/log-unlisted-clients", "GET", "", null, null, null, echoEnvoy.getContainer().gatewayIp(), null, 368, null);
    }

    @Test
    public final void echo should allow echo3 to access 'block-unlisted-clients-by-default' endpoint over https() {
        Response echoResponse = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo", null, "/block-unlisted-clients-by-default", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoLocalService);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void echo2 should allow echo3 to access 'block-unlisted-clients-by-default' endpoint over https() {
        Response echo2Response = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo2", null, "/block-unlisted-clients-by-default", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    @Tag(value="flaky")
    public final void echo should NOT allow echo2 to access 'block-unlisted-clients-by-default' endpoint over https() {
        Response echoResponse = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/block-unlisted-clients-by-default", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        String string2 = echo2Envoy.getContainer().ipAddress();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "https", "/block-unlisted-clients-by-default", "GET", "echo2", true, "echo", string2, false, 128, null);
    }

    @Test
    public final void echo2 should NOT allow unlisted clients to access 'block-unlisted-clients-by-default' endpoint over http() {
        Response echo2Response = IngressOperations.callLocalService$default(echo2Envoy.getIngressOperations(), "/block-unlisted-clients-by-default", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        String string2 = echo2Envoy.getContainer().ingressHost();
        String string3 = echo2Envoy.getContainer().gatewayIp();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "http", "/block-unlisted-clients-by-default", "GET", "", false, string2, string3, false, 128, null);
    }

    @Test
    public final void echo should NOT allow echo3 to access unlisted endpoint over https() {
        Response echoResponse = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo", null, "/unlisted-endpoint", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        String string2 = echo3Envoy.getContainer().ipAddress();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "https", "/unlisted-endpoint", "GET", "echo3", true, "echo", string2, false, 128, null);
    }

    @Test
    public final void echo2 should allow echo3 to access unlisted endpoint over https and log it() {
        Response echo2Response = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo2", null, "/unlisted-endpoint", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        String string2 = echo3Envoy.getContainer().ipAddress();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "https", "/unlisted-endpoint", "GET", "echo3", true, "echo2", null, string2, null, 320, null);
    }

    @Test
    public final void echo should NOT allow echo2 to access unlisted endpoint over https() {
        Response echoResponse = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/unlisted-endpoint", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        String string2 = echo2Envoy.getContainer().ipAddress();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "https", "/unlisted-endpoint", "GET", "echo2", true, "echo", string2, false, 128, null);
    }

    @Test
    @Tag(value="flaky")
    public final void echo2 should allow echo to access unlisted endpoint over https and log it() {
        Response echo2Response = EgressOperations.callService$default(echoEnvoy.getEgressOperations(), "echo2", null, "/unlisted-endpoint", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        String string2 = echoEnvoy.getContainer().ipAddress();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "https", "/unlisted-endpoint", "GET", "echo", true, "echo2", null, string2, null, 320, null);
    }

    @Test
    public final void echo should NOT allow source-ip-client to access unlisted endpoint over http() {
        Response echoResponse = Companion.getSourceIpClientToEchoProxy().call("/unlisted-endpoint");
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        String string2 = StringsKt.removePrefix((String)Companion.getSourceIpClientToEchoProxy().getAddress(), (CharSequence)"http://");
        String string3 = sourceIpClient.getContainer().ipAddress();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "http", "/unlisted-endpoint", "GET", "", false, string2, string3, false, 128, null);
    }

    @Test
    public final void echo2 should allow source-ip-client to access unlisted endpoint over http() {
        Response echo2Response = Companion.getSourceIpClientToEcho2Proxy().call("/unlisted-endpoint");
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "http", "/unlisted-endpoint", "GET", "", false, null, null, sourceIpClient.getContainer().ipAddress(), null, 352, null);
    }

    @Test
    public final void echo should NOT allow unlisted clients to access unlisted endpoint over http() {
        Response echoResponse = IngressOperations.callLocalService$default(echoEnvoy.getIngressOperations(), "/unlisted-endpoint", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        String string2 = echoEnvoy.getContainer().ingressHost();
        String string3 = echoEnvoy.getContainer().gatewayIp();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "http", "/unlisted-endpoint", "GET", "", false, string2, string3, false, 128, null);
    }

    @Test
    public final void echo2 should allow unlisted clients to access unlisted endpoint over http() {
        Response echo2Response = IngressOperations.callLocalService$default(echo2Envoy.getIngressOperations(), "/unlisted-endpoint", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_http.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "http", "/unlisted-endpoint", "GET", "", false, null, null, echo2Envoy.getContainer().gatewayIp(), null, 352, null);
    }

    @Test
    public final void echo should NOT allow echo3 to access 'log-unlisted-clients' endpoint with wrong http method() {
        Response echoResponse = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo", null, "/log-unlisted-clients", "POST", RequestBody.Companion.create(MediaType.Companion.get("application/json"), "{}"), 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echoEnvoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        String string2 = echo3Envoy.getContainer().ipAddress();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "https", "/log-unlisted-clients", "POST", "echo3", true, "echo", string2, false, 128, null);
    }

    @Test
    public final void echo2 should allow echo3 to access 'log-unlisted-clients' endpoint with wrong http method and log it() {
        Response echo2Response = EgressOperations.callService$default(echo3Envoy.getEgressOperations(), "echo2", null, "/log-unlisted-clients", "POST", RequestBody.Companion.create(MediaType.Companion.get("text/plain"), "{}"), 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "https", "/log-unlisted-clients", "POST", "echo3", true, null, null, echo3Envoy.getContainer().ipAddress(), null, 352, null);
    }

    @Test
    public final void echo2 should allow unlisted client with client identity header over https and log client name as untrusted() {
        Response echo2Response = echo2Envoy.getIngressOperations().callLocalServiceInsecure("/log-unlisted-clients", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-name", (Object)"service-name-from-header"))), true);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2LocalService);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        String string2 = echo2Envoy.getContainer().ingressHost();
        String string3 = echo2Envoy.getContainer().gatewayIp();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "https", "/log-unlisted-clients", "GET", "service-name-from-header (not trusted)", false, string2, null, string3, null, 320, null);
    }

    @Test
    public final void echo2 should NOT allow echo to access 'block-unlisted-clients-by-default' endpoint over https() {
        Response echo2Response = EgressOperations.callService$default(echoEnvoy.getEgressOperations(), "echo2", null, "/block-unlisted-clients-by-default", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        String string = echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_rq_completed");
        Assertions.assertThat((Integer)(string != null ? Integer.valueOf(Integer.parseInt(string)) : null)).isOne();
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        String string2 = echoEnvoy.getContainer().ipAddress();
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "https", "/block-unlisted-clients-by-default", "GET", "echo", true, "echo2", string2, false, 128, null);
    }

    public static final /* synthetic */ Function1 access$getProperties$cp() {
        return properties;
    }

    static {
        Object[] objectArray = new Extension[]{consul, sourceIpClient};
        envoyControl = new EnvoyControlClusteredExtension(consul.getServerFirst(), (Function0<? extends Map<String, ? extends Object>>)((Function0)Companion.envoyControl.1.INSTANCE), (List<? extends BeforeAllCallback>)CollectionsKt.listOf((Object[])objectArray));
        echoLocalService = new EchoServiceExtension();
        echo2LocalService = new EchoServiceExtension();
        localService = new EchoServiceExtension();
        echoConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, IncomingPermissionsLoggingModeTest.Companion.proxySettings("blockAndLog"), null, null, null, 59, null);
        echoEnvoy = new EnvoyExtension(envoyControl, echoLocalService, echoConfig, null, 8, null);
        echo2Config = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho2EnvoyAuthConfig(), null, null, IncomingPermissionsLoggingModeTest.Companion.proxySettings("log"), null, null, null, 59, null);
        echo2Envoy = new EnvoyExtension(envoyControl, echo2LocalService, echo2Config, null, 8, null);
        echo3EnvoyConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho3EnvoyAuthConfig(), null, null, echo3Config, null, null, null, 59, null);
        echo3Envoy = new EnvoyExtension(envoyControl, localService, echo3EnvoyConfig, null, 8, null);
        sourceIpClientToEchoProxy$delegate = LazyKt.lazy((Function0)Companion.sourceIpClientToEchoProxy.2.INSTANCE);
        sourceIpClientToEcho2Proxy$delegate = LazyKt.lazy((Function0)Companion.sourceIpClientToEcho2Proxy.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\bJ\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\fH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001c8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\u00020\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 R\u001b\u0010#\u001a\u00020\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\"\u001a\u0004\b$\u0010 \u00a8\u0006+"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsLoggingModeTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulMultiClusterExtension;", "echo2Config", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echo2Envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echo2LocalService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "echo3Config", "", "echo3Envoy", "echo3EnvoyConfig", "getEcho3EnvoyConfig", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echoConfig", "echoEnvoy", "echoLocalService", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlClusteredExtension;", "localService", "prefix", "properties", "Lkotlin/Function1;", "", "sourceIpClient", "Lpl/allegro/tech/servicemesh/envoycontrol/config/containers/ToxiproxyExtension;", "sourceIpClientToEcho2Proxy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/containers/ProxyOperations;", "getSourceIpClientToEcho2Proxy", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/containers/ProxyOperations;", "sourceIpClientToEcho2Proxy$delegate", "Lkotlin/Lazy;", "sourceIpClientToEchoProxy", "getSourceIpClientToEchoProxy", "sourceIpClientToEchoProxy$delegate", "createProxyToEnvoyIngress", "toxiproxy", "envoy", "proxySettings", "unlistedEndpointsPolicy", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        private final String proxySettings(String unlistedEndpointsPolicy) {
            return StringsKt.trimIndent((String)("\n            node:\n              metadata:\n                proxy_settings:\n                  incoming:\n                    unlistedEndpointsPolicy: " + unlistedEndpointsPolicy + "\n                    endpoints:\n                    - path: \"/block-unlisted-clients\"\n                      clients: [\"authorized-clients\"]\n                      unlistedClientsPolicy: blockAndLog\n                    - path: \"/log-unlisted-clients\"\n                      methods: [GET]\n                      clients: [\"authorized-clients\"]\n                      unlistedClientsPolicy: log\n                    - path: \"/block-unlisted-clients-by-default\"\n                      clients: [\"authorized-clients\"]\n                    roles:\n                    - name: authorized-clients\n                      clients: [\"echo3\", \"source-ip-client\"]\n                  outgoing:\n                    dependencies:\n                      - service: \"echo\"\n                      - service: \"echo2\"\n        "));
        }

        @NotNull
        public final EnvoyConfig getEcho3EnvoyConfig() {
            return echo3EnvoyConfig;
        }

        @NotNull
        public final ProxyOperations getSourceIpClientToEchoProxy() {
            Lazy lazy = sourceIpClientToEchoProxy$delegate;
            return (ProxyOperations)lazy.getValue();
        }

        @NotNull
        public final ProxyOperations getSourceIpClientToEcho2Proxy() {
            Lazy lazy = sourceIpClientToEcho2Proxy$delegate;
            return (ProxyOperations)lazy.getValue();
        }

        @NotNull
        public final String createProxyToEnvoyIngress(@NotNull ToxiproxyExtension toxiproxy, @NotNull EnvoyExtension envoy) {
            Intrinsics.checkNotNullParameter((Object)toxiproxy, (String)"toxiproxy");
            Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
            return toxiproxy.getContainer().createProxy(envoy.getContainer().ipAddress(), 5001);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

