/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtensionBase;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.permissions.IncomingPermissionsOverlappingPathsTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\t"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsOverlappingPathsTest;", "", "()V", "beforeEach", "", "should allow defining endpoints with policy log that are subset of blockAndLog when unlinstedEnpointsPolicy is blockAndLog", "should allow defining endpoints with policy log that are subset of blockAndLog when unlinstedEnpointsPolicy is log", "waitForEnvoysInitialized", "Companion", "envoy-control-tests"})
public final class IncomingPermissionsOverlappingPathsTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String echoYaml = "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        unlistedEndpointsPolicy: log\n        endpoints:\n          - pathRegex: \"/a/b/.+\"\n            clients: [ echo3 ]\n            unlistedClientsPolicy: log\n          - pathRegex: \"/a/.+\"\n            clients: [ echo3 ]\n            unlistedClientsPolicy: blockAndLog\n      outgoing:\n        dependencies: []";
    @NotNull
    private static final String echo3Yaml = "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        unlistedEndpointsPolicy: blockAndLog\n        endpoints:\n          - pathRegex: \"/a/b/.+\"\n            clients: [ echo3 ]\n            unlistedClientsPolicy: log\n          - pathRegex: \"/a/.+\"\n            clients: [ echo3 ]\n            unlistedClientsPolicy: blockAndLog\n      outgoing:\n        dependencies: []";
    @NotNull
    private static final String echo2Yaml = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"echo\"\n          - service: \"echo3\"";
    @NotNull
    private static final EnvoyConfig echoConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, echoYaml, null, null, null, 59, null);
    @NotNull
    private static final EnvoyConfig echo2Config = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho2EnvoyAuthConfig(), null, null, echo2Yaml, null, null, null, 59, null);
    @NotNull
    private static final EnvoyConfig echo3Config = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho3EnvoyAuthConfig(), null, null, echo3Yaml, null, null, null, 59, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension(false, 1, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echoEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echo2Envoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echo3Envoy;

    @BeforeEach
    public final void beforeEach() {
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), echoEnvoy, null, "echo", false, CollectionsKt.listOf((Object)"mtls:enabled"), 10, null);
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), echo3Envoy, null, "echo3", false, CollectionsKt.listOf((Object)"mtls:enabled"), 10, null);
        this.waitForEnvoysInitialized();
    }

    private final void waitForEnvoysInitialized() {
        AwaitAssertionsKt.untilAsserted$default(null, null, waitForEnvoysInitialized.1.INSTANCE, 3, null);
    }

    @Test
    public final void should allow defining endpoints with policy log that are subset of blockAndLog when unlinstedEnpointsPolicy is log() {
        Response response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/a/b/c", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
    }

    @Test
    public final void should allow defining endpoints with policy log that are subset of blockAndLog when unlinstedEnpointsPolicy is blockAndLog() {
        Response response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo3", null, "/a/b/c", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.overlapping-paths-fix", (Object)true)};
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])object));
        echoService = new EchoServiceExtension();
        object = envoyControl;
        EnvoyConfig envoyConfig = echoConfig;
        EchoServiceExtension echoServiceExtension = echoService;
        echoEnvoy = new EnvoyExtension((EnvoyControlExtensionBase)object, echoServiceExtension, envoyConfig, null, 8, null);
        echo2Envoy = new EnvoyExtension(envoyControl, null, echo2Config, null, 10, null);
        object = envoyControl;
        envoyConfig = echo3Config;
        echoServiceExtension = echoService;
        echo3Envoy = new EnvoyExtension((EnvoyControlExtensionBase)object, echoServiceExtension, envoyConfig, null, 8, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsOverlappingPathsTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "echo2Config", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echo2Envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echo2Yaml", "", "echo3Config", "echo3Envoy", "echo3Yaml", "echoConfig", "echoEnvoy", "echoService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "echoYaml", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

