/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtensionBase;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.permissions.IncomingPermissionsPathMatchingTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0002\u00a8\u0006\u000b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsPathMatchingTest;", "", "()V", "beforeEach", "", "echo should allow echo2 to access 'path' endpoint on exact path", "echo should allow echo2 to access 'prefix' endpoint on correct prefix path", "echo should allow echo2 to access 'regex' endpoint on correct regex path", "echo should allow echo2 to access endpoints for matched Glob patterns in the 'paths' field", "waitForEnvoysInitialized", "Companion", "envoy-control-tests"})
public final class IncomingPermissionsPathMatchingTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String echoYaml = "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        unlistedEndpointsPolicy: blockAndLog\n        endpoints:\n        - paths: \n          - /api/products\n          - /api/products/*/reviews\n          - /api/offers/**\n          - /api/**/description\n          - /*/login\n          - /**/health\n          clients: [\"echo2\"]\n        - path: \"/path\"\n          clients: [\"echo2\"]\n        - pathPrefix: \"/prefix\"\n          clients: [\"echo2\"]\n        - pathRegex: \"/regex/.*/segment\"\n          clients: [\"echo2\"]\n        roles: []\n      outgoing:\n        dependencies: []";
    @NotNull
    private static final String echo2Yaml = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"echo\"";
    @NotNull
    private static final EnvoyConfig echoConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, echoYaml, null, null, null, 59, null);
    @NotNull
    private static final EnvoyConfig echo2Config = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho2EnvoyAuthConfig(), null, null, echo2Yaml, null, null, null, 59, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension(false, 1, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echoEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echo2Envoy;

    @BeforeEach
    public final void beforeEach() {
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), echoEnvoy, null, "echo", false, CollectionsKt.listOf((Object)"mtls:enabled"), 10, null);
        this.waitForEnvoysInitialized();
    }

    private final void waitForEnvoysInitialized() {
        AwaitAssertionsKt.untilAsserted$default(null, null, waitForEnvoysInitialized.1.INSTANCE, 3, null);
    }

    @Test
    public final void echo should allow echo2 to access 'path' endpoint on exact path() {
        Response response2;
        Response it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/path", null, null, 26, null);
        boolean bl = false;
        ObjectAssert objectAssert = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/path/segment", null, null, 26, null);
        boolean bl2 = false;
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert2);
    }

    @Test
    public final void echo should allow echo2 to access 'prefix' endpoint on correct prefix path() {
        Response response2;
        Response it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/prefix", null, null, 26, null);
        boolean bl = false;
        ObjectAssert objectAssert = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/prefixes", null, null, 26, null);
        boolean bl2 = false;
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert2);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/prefix/segment", null, null, 26, null);
        boolean bl3 = false;
        ObjectAssert objectAssert3 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert3, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert3);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/wrong-prefix", null, null, 26, null);
        boolean bl4 = false;
        ObjectAssert objectAssert4 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert4, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert4);
    }

    @Test
    public final void echo should allow echo2 to access 'regex' endpoint on correct regex path() {
        Response response2;
        Response it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/regex/1/segment", null, null, 26, null);
        boolean bl = false;
        ObjectAssert objectAssert = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/regex/param-1/segment", null, null, 26, null);
        boolean bl2 = false;
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert2);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/regex/param/param2/segment", null, null, 26, null);
        boolean bl3 = false;
        ObjectAssert objectAssert3 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert3, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert3);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/regex/1", null, null, 26, null);
        boolean bl4 = false;
        ObjectAssert objectAssert4 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert4, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert4);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/regex/param/bad-segment", null, null, 26, null);
        boolean bl5 = false;
        ObjectAssert objectAssert5 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert5, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert5);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/regex/param/segment/last-segment", null, null, 26, null);
        boolean bl6 = false;
        ObjectAssert objectAssert6 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert6, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert6);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/abc/regex/1/segment", null, null, 26, null);
        boolean bl7 = false;
        ObjectAssert objectAssert7 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert7, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert7);
    }

    @Test
    public final void echo should allow echo2 to access endpoints for matched Glob patterns in the 'paths' field() {
        Response response2;
        Response it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/api/products", null, null, 26, null);
        boolean bl = false;
        ObjectAssert objectAssert = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/api/products/some/reviews", null, null, 26, null);
        boolean bl2 = false;
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert2);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/api/offers/electronics/phones", null, null, 26, null);
        boolean bl3 = false;
        ObjectAssert objectAssert3 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert3, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert3);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/some/status/health", null, null, 26, null);
        boolean bl4 = false;
        ObjectAssert objectAssert4 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert4, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert4);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/api/path/with/description", null, null, 26, null);
        boolean bl5 = false;
        ObjectAssert objectAssert5 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert5, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert5);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/api/paths/with/description", null, null, 26, null);
        boolean bl6 = false;
        ObjectAssert objectAssert6 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert6, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert6);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/api/login", null, null, 26, null);
        boolean bl7 = false;
        ObjectAssert objectAssert7 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert7, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert7);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/api/products/too/many/reviews", null, null, 26, null);
        boolean bl8 = false;
        ObjectAssert objectAssert8 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert8, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert8);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/api/products/forbidden", null, null, 26, null);
        boolean bl9 = false;
        ObjectAssert objectAssert9 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert9, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert9);
        it = response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/status/health/login", null, null, 26, null);
        boolean bl10 = false;
        ObjectAssert objectAssert10 = Assertions.assertThat((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert10, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert10);
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.overlapping-paths-fix", (Object)true)};
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])object));
        echoService = new EchoServiceExtension();
        object = envoyControl;
        EnvoyConfig envoyConfig = echoConfig;
        EchoServiceExtension echoServiceExtension = echoService;
        echoEnvoy = new EnvoyExtension((EnvoyControlExtensionBase)object, echoServiceExtension, envoyConfig, null, 8, null);
        echo2Envoy = new EnvoyExtension(envoyControl, null, echo2Config, null, 10, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsPathMatchingTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "echo2Config", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echo2Envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echo2Yaml", "", "echoConfig", "echoEnvoy", "echoService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "echoYaml", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

