/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.EnvoyAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtensionBase;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.permissions.IncomingPermissionsRbacActionTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsRbacActionTest;", "", "()V", "afterEach", "", "beforeEach", "incoming permissions logs should contain rbacAction", "rbacAction should be set to shadow_denied when shadow_engine result is denied and upstream is unavailable", "Companion", "envoy-control-tests"})
public final class IncomingPermissionsRbacActionTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String echoYaml = "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        endpoints:\n        - path: \"/path\"\n          unlistedClientsPolicy: log\n          clients: []\n      outgoing:\n        dependencies:\n          - service: \"echo\"\n          - service: \"failing-echo\"";
    @NotNull
    private static final EnvoyConfig echoConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, echoYaml, null, null, null, 59, null);
    @NotNull
    private static final EnvoyConfig failingEchoConfig;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echoEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension failingEchoEnvoy;

    @BeforeEach
    public final void beforeEach() {
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), echoEnvoy, null, "echo", false, null, 26, null);
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), failingEchoEnvoy, null, "failing-echo", false, null, 26, null);
        echoEnvoy.getContainer().getLogRecorder().recordLogs((Function1<? super String, Boolean>)((Function1)beforeEach.1.INSTANCE));
        failingEchoEnvoy.getContainer().getLogRecorder().recordLogs((Function1<? super String, Boolean>)((Function1)beforeEach.2.INSTANCE));
        String[] stringArray = new String[]{"echo", "failing-echo"};
        echoEnvoy.waitForAvailableEndpoints(stringArray);
    }

    @AfterEach
    public final void afterEach() {
        echoEnvoy.getContainer().getLogRecorder().stopRecording();
    }

    @Test
    public final void incoming permissions logs should contain rbacAction() {
        Response response2 = EgressOperations.callService$default(echoEnvoy.getEgressOperations(), "echo", null, "/path", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "http", null, null, null, null, null, null, null, null, "shadow_denied", null, 1534, null);
    }

    @Test
    public final void rbacAction should be set to shadow_denied when shadow_engine result is denied and upstream is unavailable() {
        Response response2 = EgressOperations.callService$default(echoEnvoy.getEgressOperations(), "failing-echo", null, "/path", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isUnreachable((ObjectAssert<Response>)objectAssert);
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)failingEchoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert2, "http", null, null, null, null, null, null, null, null, "shadow_denied", "503", 510, null);
    }

    static {
        Object object = EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig();
        Object object2 = echoYaml;
        failingEchoConfig = EnvoyConfig.copy$default((EnvoyConfig)object, null, "failing-echo", (String)object2, null, null, null, 57, null);
        consul = new ConsulExtension(false, 1, null);
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair)TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.enabled", (Object)true)));
        echoService = new EchoServiceExtension();
        object = envoyControl;
        object2 = echoConfig;
        EchoServiceExtension echoServiceExtension = echoService;
        echoEnvoy = new EnvoyExtension((EnvoyControlExtensionBase)object, echoServiceExtension, (EnvoyConfig)object2, null, 8, null);
        failingEchoEnvoy = new EnvoyExtension(envoyControl, null, failingEchoConfig, null, 10, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsRbacActionTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "echoConfig", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echoEnvoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echoService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "echoYaml", "", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "failingEchoConfig", "failingEchoEnvoy", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

