/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.reliability;

import eu.rekawek.toxiproxy.Proxy;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Testcontainers;
import pl.allegro.tech.servicemesh.envoycontrol.config.BaseEnvoyTest;
import pl.allegro.tech.servicemesh.envoycontrol.config.containers.ToxiproxyContainer;
import pl.allegro.tech.servicemesh.envoycontrol.utils.Ports;

@Testcontainers
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/reliability/Toxiproxy;", "", "()V", "Companion", "envoy-control-tests"})
public final class Toxiproxy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int toxiproxyGrpcPort = Ports.INSTANCE.nextAvailable();
    private static final int toxiproxyGrpcPort2 = Ports.INSTANCE.nextAvailable();
    private static final int ec1HttpPort = Ports.INSTANCE.nextAvailable();
    private static final int ec2HttpPort = Ports.INSTANCE.nextAvailable();
    private static final int internalConsulProxyPort = 1337;
    private static final int internalEnvoyControl1GrpcPort = 1338;
    private static final int internalEnvoyControl2GrpcPort = 1339;
    private static final int internalEnvoyControl1HttpPort = 1340;
    private static final int internalEnvoyControl2HttpPort = 1341;
    @NotNull
    private static final ToxiproxyContainer toxiContainer;
    @NotNull
    private static final ToxiproxyClient client;
    @NotNull
    private static final Proxy consulProxy;
    private static final int externalConsulPort;
    private static final int externalEnvoyControl1GrpcPort;
    private static final int externalEnvoyControl2GrpcPort;
    private static final int externalEnvoyControl1HttpPort;
    private static final int externalEnvoyControl2HttpPort;
    @NotNull
    private static final Proxy envoyControl1Proxy;
    @NotNull
    private static final Proxy envoyControl2Proxy;
    @NotNull
    private static final Proxy envoyControl1HttpProxy;
    @NotNull
    private static final Proxy envoyControl2HttpProxy;

    private Toxiproxy() {
    }

    static {
        Integer[] integerArray = new Integer[]{8474, 1337, 1338, 1339, 1340, 1341};
        GenericContainer genericContainer = ((ToxiproxyContainer)new ToxiproxyContainer(0, 1, null).withNetwork(BaseEnvoyTest.Companion.getNetwork())).withExposedPorts(integerArray);
        Intrinsics.checkNotNullExpressionValue((Object)genericContainer, (String)"withExposedPorts(...)");
        toxiContainer = (ToxiproxyContainer)genericContainer;
        toxiContainer.start();
        client = toxiContainer.getClient();
        Proxy proxy = client.createProxy("consul", "0.0.0.0:1337", BaseEnvoyTest.Companion.getConsul().ipAddress() + ":" + BaseEnvoyTest.Companion.getConsul().getInternalPort());
        Intrinsics.checkNotNullExpressionValue((Object)proxy, (String)"createProxy(...)");
        consulProxy = proxy;
        Integer n = toxiContainer.getMappedPort(1337);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getMappedPort(...)");
        externalConsulPort = ((Number)n).intValue();
        Integer n2 = toxiContainer.getMappedPort(1338);
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getMappedPort(...)");
        externalEnvoyControl1GrpcPort = ((Number)n2).intValue();
        Integer n3 = toxiContainer.getMappedPort(1339);
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getMappedPort(...)");
        externalEnvoyControl2GrpcPort = ((Number)n3).intValue();
        Integer n4 = toxiContainer.getMappedPort(1340);
        Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"getMappedPort(...)");
        externalEnvoyControl1HttpPort = ((Number)n4).intValue();
        Integer n5 = toxiContainer.getMappedPort(1341);
        Intrinsics.checkNotNullExpressionValue((Object)n5, (String)"getMappedPort(...)");
        externalEnvoyControl2HttpPort = ((Number)n5).intValue();
        Proxy proxy2 = client.createProxy("envoyControl1", "0.0.0.0:1338", toxiContainer.hostIp() + ":" + toxiproxyGrpcPort);
        Intrinsics.checkNotNullExpressionValue((Object)proxy2, (String)"createProxy(...)");
        envoyControl1Proxy = proxy2;
        Proxy proxy3 = client.createProxy("envoyControl2", "0.0.0.0:1339", toxiContainer.hostIp() + ":" + toxiproxyGrpcPort2);
        Intrinsics.checkNotNullExpressionValue((Object)proxy3, (String)"createProxy(...)");
        envoyControl2Proxy = proxy3;
        Proxy proxy4 = client.createProxy("ec1ToEc2", "0.0.0.0:1340", toxiContainer.hostIp() + ":" + ec1HttpPort);
        Intrinsics.checkNotNullExpressionValue((Object)proxy4, (String)"createProxy(...)");
        envoyControl1HttpProxy = proxy4;
        Proxy proxy5 = client.createProxy("ec2ToEc1", "0.0.0.0:1341", toxiContainer.hostIp() + ":" + ec2HttpPort);
        Intrinsics.checkNotNullExpressionValue((Object)proxy5, (String)"createProxy(...)");
        envoyControl2HttpProxy = proxy5;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0017\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u001b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0011\u0010\u001d\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\fR\u0011\u0010\u001f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\fR\u000e\u0010!\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\fR\u0011\u0010,\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\f\u00a8\u0006."}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/reliability/Toxiproxy$Companion;", "", "()V", "client", "Leu/rekawek/toxiproxy/ToxiproxyClient;", "consulProxy", "Leu/rekawek/toxiproxy/Proxy;", "getConsulProxy", "()Leu/rekawek/toxiproxy/Proxy;", "ec1HttpPort", "", "getEc1HttpPort", "()I", "ec2HttpPort", "getEc2HttpPort", "envoyControl1HttpProxy", "getEnvoyControl1HttpProxy", "envoyControl1Proxy", "getEnvoyControl1Proxy", "envoyControl2HttpProxy", "getEnvoyControl2HttpProxy", "envoyControl2Proxy", "getEnvoyControl2Proxy", "externalConsulPort", "getExternalConsulPort", "externalEnvoyControl1GrpcPort", "getExternalEnvoyControl1GrpcPort", "externalEnvoyControl1HttpPort", "getExternalEnvoyControl1HttpPort", "externalEnvoyControl2GrpcPort", "getExternalEnvoyControl2GrpcPort", "externalEnvoyControl2HttpPort", "getExternalEnvoyControl2HttpPort", "internalConsulProxyPort", "internalEnvoyControl1GrpcPort", "internalEnvoyControl1HttpPort", "internalEnvoyControl2GrpcPort", "internalEnvoyControl2HttpPort", "toxiContainer", "Lpl/allegro/tech/servicemesh/envoycontrol/config/containers/ToxiproxyContainer;", "getToxiContainer", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/containers/ToxiproxyContainer;", "toxiproxyGrpcPort", "getToxiproxyGrpcPort", "toxiproxyGrpcPort2", "getToxiproxyGrpcPort2", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public final int getToxiproxyGrpcPort() {
            return toxiproxyGrpcPort;
        }

        public final int getToxiproxyGrpcPort2() {
            return toxiproxyGrpcPort2;
        }

        public final int getEc1HttpPort() {
            return ec1HttpPort;
        }

        public final int getEc2HttpPort() {
            return ec2HttpPort;
        }

        @NotNull
        public final ToxiproxyContainer getToxiContainer() {
            return toxiContainer;
        }

        @NotNull
        public final Proxy getConsulProxy() {
            return consulProxy;
        }

        public final int getExternalConsulPort() {
            return externalConsulPort;
        }

        public final int getExternalEnvoyControl1GrpcPort() {
            return externalEnvoyControl1GrpcPort;
        }

        public final int getExternalEnvoyControl2GrpcPort() {
            return externalEnvoyControl2GrpcPort;
        }

        public final int getExternalEnvoyControl1HttpPort() {
            return externalEnvoyControl1HttpPort;
        }

        public final int getExternalEnvoyControl2HttpPort() {
            return externalEnvoyControl2HttpPort;
        }

        @NotNull
        public final Proxy getEnvoyControl1Proxy() {
            return envoyControl1Proxy;
        }

        @NotNull
        public final Proxy getEnvoyControl2Proxy() {
            return envoyControl2Proxy;
        }

        @NotNull
        public final Proxy getEnvoyControl1HttpProxy() {
            return envoyControl1HttpProxy;
        }

        @NotNull
        public final Proxy getEnvoyControl2HttpProxy() {
            return envoyControl2HttpProxy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

