/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.routing;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.HttpsEchoResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.GenericServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoContainerKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoResponse;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.routing.RoutingHeadersTest;
import pl.allegro.tech.servicemesh.envoycontrol.routing.TestBase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/RoutingHeadersTest;", "Lpl/allegro/tech/servicemesh/envoycontrol/routing/TestBase;", "()V", "registerServices", "", "should add correct x-service-tag-preference header to upstream request", "should add upstream service tags to a response", "should add upstream service tags to a response even if autoServiceTag is disabled", "should not override service-tag preference header already set in the request", "Companion", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nRoutingHeadersTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutingHeadersTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/RoutingHeadersTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1855#2,2:178\n1855#2,2:180\n*S KotlinDebug\n*F\n+ 1 RoutingHeadersTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/RoutingHeadersTest\n*L\n33#1:178,2\n36#1:180,2\n*E\n"})
public final class RoutingHeadersTest
extends TestBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl = new EnvoyControlExtension(TestBase.consul, TestBase.Companion.properties(true));
    @RegisterExtension
    @JvmField
    @NotNull
    public static final GenericServiceExtension<HttpsEchoContainer> echoService = new GenericServiceExtension<ServiceContainer>(new HttpsEchoContainer());
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy = new EnvoyExtension(envoyControl, null, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getRandomConfigFile(), null, null, TestBase.Companion.getProxySettings(), null, null, null, 59, null), null, 10, null);

    public RoutingHeadersTest() {
        super((ServiceExtension)echoService, envoy);
    }

    private final void registerServices() {
        String service;
        Object element$iv;
        Object[] objectArray = new String[]{"echo", "echo-disabled", "echo-one-tag", "echo-no-tag"};
        Object $this$forEach$iv = (Object[])CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            service = (String)element$iv;
            boolean bl = false;
            ConsulOperations consulOperations = TestBase.consul.getServer().getOperations();
            GenericServiceExtension<HttpsEchoContainer> genericServiceExtension = echoService;
            List<String> list = TestBase.Companion.getAllTags();
            ConsulOperations.registerService$default(consulOperations, genericServiceExtension, null, service, false, list, null, 42, null);
        }
        $this$forEach$iv = new String[]{"echo", "echo-disabled", "echo-one-tag", "echo-no-tag"};
        $this$forEach$iv = CollectionsKt.listOf((Object[])$this$forEach$iv);
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            service = (String)element$iv;
            boolean bl = false;
            this.waitForEndpointReady(service, (ServiceExtension)echoService, envoy);
        }
    }

    @Test
    public final void should add correct x-service-tag-preference header to upstream request() {
        this.registerServices();
        HttpsEchoResponse echoResponse = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(envoy.getEgressOperations(), "echo", null, null, null, null, 30, null));
        HttpsEchoResponse echoDisabledResponse = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(envoy.getEgressOperations(), "echo-disabled", null, null, null, null, 30, null));
        HttpsEchoResponse echoOneTagResponse = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(envoy.getEgressOperations(), "echo-one-tag", null, null, null, null, 30, null));
        HttpsEchoResponse echoNoTagResponse = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(envoy.getEgressOperations(), "echo-no-tag", null, null, null, null, 30, null));
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
        Assertions.assertThat(echoResponse.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"ipsum|lorem");
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)echoDisabledResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert2);
        Assertions.assertThat(echoDisabledResponse.getRequestHeaders()).doesNotContainKey((Object)"x-service-tag-preference");
        ObjectAssert objectAssert3 = Assertions.assertThat((Object)echoOneTagResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert3, (String)"assertThat(...)");
        HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert3);
        Assertions.assertThat(echoOneTagResponse.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"one");
        ObjectAssert objectAssert4 = Assertions.assertThat((Object)echoNoTagResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert4, (String)"assertThat(...)");
        HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert4);
        Assertions.assertThat(echoNoTagResponse.getRequestHeaders()).doesNotContainKey((Object)"x-service-tag-preference");
    }

    @Test
    public final void should not override service-tag preference header already set in the request() {
        this.registerServices();
        HttpsEchoResponse echoResponse = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(envoy.getEgressOperations(), "echo", MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-tag-preference", (Object)"custom|ipsum|lorem")), null, null, null, 28, null));
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
        Assertions.assertThat(echoResponse.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"custom|ipsum|lorem");
    }

    @Test
    public final void should add upstream service tags to a response() {
        this.upstreamServiceTagsInResponseTest("echo", (Function1<? super Response, Unit>)((Function1)should add upstream service tags to a response.1.INSTANCE));
    }

    @Test
    public final void should add upstream service tags to a response even if autoServiceTag is disabled() {
        this.upstreamServiceTagsInResponseTest("echo-disabled", (Function1<? super Response, Unit>)((Function1)should add upstream service tags to a response even if autoServiceTag is disabled.1.INSTANCE));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/RoutingHeadersTest$Companion;", "", "()V", "echoService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/GenericServiceExtension;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoContainer;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

