/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.routing;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.routing.RoutingPolicyTestBase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/RoutingPolicyTest;", "Lpl/allegro/tech/servicemesh/envoycontrol/routing/RoutingPolicyTestBase;", "()V", "should change routing when instance with prefered tag appears", "", "should change routing when instance with prefered tag disappers", "should not filter service instances if autoServiceTag is false", "Companion", "envoy-control-tests"})
public final class RoutingPolicyTest
extends RoutingPolicyTestBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension autoServiceTagEnabledEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension autoServiceTagDisabledEnvoy;

    public RoutingPolicyTest() {
        super(envoyControl, autoServiceTagEnabledEnvoy, autoServiceTagDisabledEnvoy);
    }

    @Test
    public final void should not filter service instances if autoServiceTag is false() {
        Object[] objectArray = new String[3];
        ConsulOperations consulOperations = RoutingPolicyTestBase.consul.getServer().getOperations();
        EchoServiceExtension echoServiceExtension = RoutingPolicyTestBase.ipsumEchoService;
        Object[] objectArray2 = new String[]{"ipsum", "other"};
        List list = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[0] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = RoutingPolicyTestBase.consul.getServer().getOperations();
        echoServiceExtension = RoutingPolicyTestBase.loremEchoService;
        list = CollectionsKt.listOf((Object)"lorem");
        objectArray[1] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = RoutingPolicyTestBase.consul.getServer().getOperations();
        echoServiceExtension = RoutingPolicyTestBase.otherEchoService;
        list = CollectionsKt.emptyList();
        objectArray[2] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])objectArray));
        this.waitForEndpointReady("echo", RoutingPolicyTestBase.ipsumEchoService, autoServiceTagEnabledEnvoy);
        CallStats stats2 = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, null, 14, null);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(RoutingPolicyTestBase.ipsumEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
        Assertions.assertThat((int)stats2.hits(RoutingPolicyTestBase.loremEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
        Assertions.assertThat((int)stats2.hits(RoutingPolicyTestBase.otherEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
    }

    @Test
    public final void should change routing when instance with prefered tag disappers() {
        ConsulOperations consulOperations = RoutingPolicyTestBase.consul.getServer().getOperations();
        Object[] objectArray = RoutingPolicyTestBase.ipsumEchoService;
        Object object = new String[]{"ipsum", "other"};
        Object object2 = CollectionsKt.listOf((Object[])object);
        String ipsumId = ConsulOperations.registerService$default(consulOperations, (ServiceExtension)objectArray, null, "echo", false, (List)object2, null, 42, null);
        objectArray = RoutingPolicyTestBase.consul.getServer().getOperations();
        object2 = RoutingPolicyTestBase.otherEchoService;
        object = CollectionsKt.listOf((Object)"other");
        String otherId = ConsulOperations.registerService$default((ConsulOperations)objectArray, (ServiceExtension)object2, null, "echo", false, (List)object, null, 42, null);
        objectArray = new String[]{ipsumId, otherId};
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])objectArray));
        this.waitForEndpointReady("echo", RoutingPolicyTestBase.otherEchoService, autoServiceTagDisabledEnvoy);
        this.waitForEndpointReady("echo", RoutingPolicyTestBase.ipsumEchoService, autoServiceTagEnabledEnvoy);
        CallStats statsNoAutoServiceTag = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, null, 14, null);
        CallStats statsAutoServiceTag = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, null, 14, null);
        CallStats stats2 = statsNoAutoServiceTag;
        boolean bl = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(RoutingPolicyTestBase.ipsumEchoService)).isEqualTo(5);
        Assertions.assertThat((int)stats2.hits(RoutingPolicyTestBase.otherEchoService)).isEqualTo(5);
        stats2 = statsAutoServiceTag;
        boolean bl2 = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(RoutingPolicyTestBase.ipsumEchoService)).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(RoutingPolicyTestBase.otherEchoService)).isEqualTo(0);
        RoutingPolicyTestBase.consul.getServer().getOperations().deregisterService(ipsumId);
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object)otherId));
        this.waitForEndpointRemoved("echo", RoutingPolicyTestBase.ipsumEchoService, autoServiceTagDisabledEnvoy);
        this.waitForEndpointRemoved("echo", RoutingPolicyTestBase.ipsumEchoService, autoServiceTagEnabledEnvoy);
        CallStats statsNoAutoServiceTagAfterNoIpsum = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, null, 14, null);
        CallStats statsAutoServiceTagAfterNoIpsum = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, null, 12, null);
        CallStats stats3 = statsNoAutoServiceTagAfterNoIpsum;
        boolean bl3 = false;
        Assertions.assertThat((int)stats3.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats3.hits(RoutingPolicyTestBase.otherEchoService)).isEqualTo(10);
        stats3 = statsAutoServiceTagAfterNoIpsum;
        boolean bl4 = false;
        Assertions.assertThat((int)stats3.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats3.getFailedHits()).isEqualTo(10);
    }

    @Test
    public final void should change routing when instance with prefered tag appears() {
        ConsulOperations consulOperations = RoutingPolicyTestBase.consul.getServer().getOperations();
        EchoServiceExtension echoServiceExtension = RoutingPolicyTestBase.otherEchoService;
        List list = CollectionsKt.emptyList();
        String otherEchoId = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object)otherEchoId));
        this.waitForEndpointReady("echo", RoutingPolicyTestBase.otherEchoService, autoServiceTagDisabledEnvoy);
        CallStats statsAutoServiceTagAfterOther = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, null, 12, null);
        CallStats statsNoAutoServiceTagAfterOther = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, null, 14, null);
        Object[] stats2 = statsAutoServiceTagAfterOther;
        boolean bl = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.getFailedHits()).isEqualTo(10);
        stats2 = statsNoAutoServiceTagAfterOther;
        boolean $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$72 = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(RoutingPolicyTestBase.otherEchoService)).isEqualTo(10);
        stats2 = RoutingPolicyTestBase.consul.getServer().getOperations();
        EchoServiceExtension $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$72 = RoutingPolicyTestBase.loremEchoService;
        List list2 = CollectionsKt.listOf((Object)"lorem");
        String loremEchoId = ConsulOperations.registerService$default((ConsulOperations)stats2, $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$72, null, "echo", false, list2, null, 42, null);
        stats2 = new String[]{otherEchoId, loremEchoId};
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])stats2));
        this.waitForEndpointReady("echo", RoutingPolicyTestBase.loremEchoService, autoServiceTagDisabledEnvoy);
        this.waitForEndpointReady("echo", RoutingPolicyTestBase.loremEchoService, autoServiceTagEnabledEnvoy);
        CallStats statsAutoServiceTagAfterLorem = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, null, 14, null);
        CallStats statsNoAutoServiceTagAfterLorem = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, null, 14, null);
        Object[] stats3 = statsAutoServiceTagAfterLorem;
        boolean bl2 = false;
        Assertions.assertThat((int)stats3.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats3.hits(RoutingPolicyTestBase.loremEchoService)).isEqualTo(10);
        Assertions.assertThat((int)stats3.hits(RoutingPolicyTestBase.otherEchoService)).isEqualTo(0);
        stats3 = statsNoAutoServiceTagAfterLorem;
        boolean $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$82 = false;
        Assertions.assertThat((int)stats3.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats3.hits(RoutingPolicyTestBase.loremEchoService)).isEqualTo(5);
        Assertions.assertThat((int)stats3.hits(RoutingPolicyTestBase.otherEchoService)).isEqualTo(5);
        stats3 = RoutingPolicyTestBase.consul.getServer().getOperations();
        EchoServiceExtension $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$82 = RoutingPolicyTestBase.ipsumEchoService;
        Object[] objectArray = new String[]{"noise", "ipsum"};
        List list3 = CollectionsKt.listOf((Object[])objectArray);
        String ipsumEchoId = ConsulOperations.registerService$default((ConsulOperations)stats3, $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$82, null, "echo", false, list3, null, 42, null);
        stats3 = new String[]{otherEchoId, loremEchoId, ipsumEchoId};
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])stats3));
        this.waitForEndpointReady("echo", RoutingPolicyTestBase.ipsumEchoService, autoServiceTagDisabledEnvoy);
        this.waitForEndpointReady("echo", RoutingPolicyTestBase.ipsumEchoService, autoServiceTagEnabledEnvoy);
        CallStats statsAutoServiceTagAfterIpsum = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, null, 14, null);
        CallStats statsNoAutoServiceTagAfterIpsum = RoutingPolicyTestBase.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, null, 14, null);
        CallStats stats4 = statsAutoServiceTagAfterIpsum;
        boolean bl3 = false;
        Assertions.assertThat((int)stats4.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats4.hits(RoutingPolicyTestBase.ipsumEchoService)).isEqualTo(10);
        Assertions.assertThat((int)stats4.hits(RoutingPolicyTestBase.loremEchoService)).isEqualTo(0);
        Assertions.assertThat((int)stats4.hits(RoutingPolicyTestBase.otherEchoService)).isEqualTo(0);
        stats4 = statsNoAutoServiceTagAfterIpsum;
        boolean bl4 = false;
        Assertions.assertThat((int)stats4.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats4.hits(RoutingPolicyTestBase.ipsumEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
        Assertions.assertThat((int)stats4.hits(RoutingPolicyTestBase.loremEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
        Assertions.assertThat((int)stats4.hits(RoutingPolicyTestBase.otherEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.preference-routing.enable-for-all", (Object)false), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.preference-routing.enable-for-services", (Object)CollectionsKt.emptyList())};
        envoyControl = new EnvoyControlExtension(RoutingPolicyTestBase.consul, MapsKt.plus(RoutingPolicyTestBase.Companion.getProperties(), (Map)MapsKt.mapOf((Pair[])pairArray)));
        autoServiceTagEnabledEnvoy = new EnvoyExtension(envoyControl, null, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getRandomConfigFile(), null, null, RoutingPolicyTestBase.Companion.getAutoServiceTagEnabledSettings(), null, null, null, 59, null), null, 10, null);
        autoServiceTagDisabledEnvoy = new EnvoyExtension(envoyControl, null, null, null, 14, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/RoutingPolicyTest$Companion;", "", "()V", "autoServiceTagDisabledEnvoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "autoServiceTagEnabledEnvoy", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

