/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.routing;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.sharing.ContainerExtension;
import pl.allegro.tech.servicemesh.envoycontrol.routing.ServiceTagPreferenceTestBase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceEnableForServicesTest;", "Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTestBase;", "()V", "preference routing enabled only for selected service", "", "report", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;", "Companion", "envoy-control-tests"})
public final class ServiceTagPreferenceEnableForServicesTest
extends ServiceTagPreferenceTestBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @NotNull
    private static final HttpsEchoExtension echoGlobal;
    @NotNull
    private static final HttpsEchoExtension echoVte3;
    @NotNull
    private static final EnvoyExtension envoyGlobal;
    @NotNull
    private static final EnvoyExtension envoyGlobalEnabled;
    @NotNull
    private static final List<HttpsEchoExtension> allServices;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ContainerExtension.Parallel containers;

    public ServiceTagPreferenceEnableForServicesTest() {
        Object[] objectArray = new HttpsEchoExtension[]{echoGlobal, echoVte3};
        super(CollectionsKt.listOf((Object[])objectArray));
    }

    @Test
    public final void preference routing enabled only for selected service() {
        ServiceTagPreferenceTestBase.assertResponsesFromRandomInstances$default(this, ServiceTagPreferenceTestBase.callServiceRepeatedly$default(this, envoyGlobal, "echo", null, null, 6, null), null, 1, null);
        this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(this, envoyGlobalEnabled, "echo", null, null, 6, null), echoGlobal);
    }

    @Override
    @NotNull
    public String report(@NotNull CallStats $this$report) {
        Intrinsics.checkNotNullParameter((Object)$this$report, (String)"<this>");
        return "hits: {global: " + $this$report.hits(echoGlobal) + ", vte3: " + $this$report.hits(echoVte3) + "}";
    }

    @JvmStatic
    @BeforeAll
    public static final void registerServices() {
        Companion.registerServices();
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.preference-routing.enable-for-all", (Object)false), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.preference-routing.enable-for-services", (Object)CollectionsKt.listOf((Object)"enabled-service"))};
        envoyControl = new EnvoyControlExtension(ServiceTagPreferenceTestBase.consul, MapsKt.plus(ServiceTagPreferenceTestBase.Companion.getProperties(), (Map)MapsKt.mapOf((Pair[])objectArray)));
        echoGlobal = new HttpsEchoExtension();
        echoVte3 = new HttpsEchoExtension();
        envoyGlobal = new EnvoyExtension(envoyControl, null, null, null, 14, null);
        envoyGlobalEnabled = new EnvoyExtension(envoyControl, null, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getRandomConfigFile(), null, "enabled-service", null, null, null, null, 61, null), null, 10, null);
        objectArray = new HttpsEchoExtension[]{echoGlobal, echoVte3};
        allServices = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new ContainerExtension[]{echoGlobal, echoVte3, envoyGlobal, envoyGlobalEnabled};
        containers = new ContainerExtension.Parallel((ContainerExtension[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceEnableForServicesTest$Companion;", "", "()V", "allServices", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoExtension;", "getAllServices", "()Ljava/util/List;", "containers", "Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension$Parallel;", "echoGlobal", "getEchoGlobal", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoExtension;", "echoVte3", "getEchoVte3", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoyGlobal", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "getEnvoyGlobal", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyGlobalEnabled", "getEnvoyGlobalEnabled", "registerServices", "", "envoy-control-tests"})
    @SourceDebugExtension(value={"SMAP\nServiceTagPreferenceTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceTagPreferenceTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceEnableForServicesTest$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,432:1\n1855#2:433\n1855#2,2:434\n1856#2:436\n*S KotlinDebug\n*F\n+ 1 ServiceTagPreferenceTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceEnableForServicesTest$Companion\n*L\n237#1:433\n238#1:434,2\n237#1:436\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpsEchoExtension getEchoGlobal() {
            return echoGlobal;
        }

        @NotNull
        public final HttpsEchoExtension getEchoVte3() {
            return echoVte3;
        }

        @NotNull
        public final EnvoyExtension getEnvoyGlobal() {
            return envoyGlobal;
        }

        @NotNull
        public final EnvoyExtension getEnvoyGlobalEnabled() {
            return envoyGlobalEnabled;
        }

        @NotNull
        public final List<HttpsEchoExtension> getAllServices() {
            return allServices;
        }

        @JvmStatic
        @BeforeAll
        public final void registerServices() {
            Object[] objectArray = ServiceTagPreferenceTestBase.consul.getServer().getOperations();
            List list = CollectionsKt.listOf((Object)"global");
            ConsulOperations.registerService$default((ConsulOperations)objectArray, this.getEchoGlobal(), null, "echo", false, list, null, 42, null);
            objectArray = ServiceTagPreferenceTestBase.consul.getServer().getOperations();
            list = CollectionsKt.listOf((Object)"vte3");
            ConsulOperations.registerService$default((ConsulOperations)objectArray, this.getEchoVte3(), null, "echo", false, list, null, 42, null);
            objectArray = new EnvoyExtension[]{this.getEnvoyGlobal(), this.getEnvoyGlobalEnabled()};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EnvoyExtension envoy = (EnvoyExtension)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = Companion.getAllServices();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    HttpsEchoExtension service = (HttpsEchoExtension)element$iv2;
                    boolean bl2 = false;
                    envoy.waitForClusterEndpointHealthy("echo", service.container().ipAddress());
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

