/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.routing;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestClassOrder;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoContainerKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoResponse;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.sharing.ContainerExtension;
import pl.allegro.tech.servicemesh.envoycontrol.routing.ServiceTagPreferenceTestBase;

@TestClassOrder(value=ClassOrderer.OrderAnnotation.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00062\u00020\u0001:\u0005\u0006\u0007\b\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest;", "Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTestBase;", "()V", "report", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;", "Companion", "Extensions", "ThenLvteInstanceIsDown", "WhenAllServicesAreUp", "WhenAllServicesAreUpSetup", "envoy-control-tests"})
public final class ServiceTagPreferenceTest
extends ServiceTagPreferenceTestBase {
    @NotNull
    public static final Companion Companion;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @NotNull
    private static final EnvoyExtension envoyGlobal;
    @NotNull
    private static final EnvoyExtension envoyGlobalDisabled;
    @NotNull
    private static final EnvoyExtension envoyVte12;
    @NotNull
    private static final EnvoyExtension envoyVte12Lvte1;
    @NotNull
    private static final HttpsEchoExtension echoGlobal;
    @NotNull
    private static final HttpsEchoExtension echoVte12;
    @NotNull
    private static final HttpsEchoExtension echoVte12Lvte1;
    @NotNull
    private static final HttpsEchoExtension echoVte33;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ContainerExtension.Parallel containers;
    @NotNull
    private static final List<HttpsEchoExtension> allServices;

    public ServiceTagPreferenceTest() {
        super(allServices);
    }

    @Override
    @NotNull
    public String report(@NotNull CallStats $this$report) {
        Intrinsics.checkNotNullParameter((Object)$this$report, (String)"<this>");
        return "hits: {global: " + $this$report.hits(echoGlobal) + ", vte12: " + $this$report.hits(echoVte12) + ", lvte1: " + $this$report.hits(echoVte12Lvte1) + ", vte33: " + $this$report.hits(echoVte33) + "}";
    }

    static {
        Object[] objectArray;
        Companion = new Companion(null);
        envoyControl = new EnvoyControlExtension(ServiceTagPreferenceTestBase.consul, ServiceTagPreferenceTestBase.Companion.getProperties());
        envoyGlobal = new EnvoyExtension(envoyControl, null, null, null, 14, null);
        envoyGlobalDisabled = new EnvoyExtension(envoyControl, null, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getRandomConfigFile(), null, "disabled-service", null, null, null, null, 61, null), null, 10, null);
        Object[] it = objectArray = new EnvoyExtension(envoyControl, null, null, null, 14, null);
        boolean bl = false;
        it.getContainer().withEnv("DEFAULT_SERVICE_TAG_PREFERENCE", "vte12|global");
        envoyVte12 = objectArray;
        it = objectArray = new EnvoyExtension(envoyControl, null, null, null, 14, null);
        boolean bl2 = false;
        it.getContainer().withEnv("DEFAULT_SERVICE_TAG_PREFERENCE", "lvte1|vte12|global");
        envoyVte12Lvte1 = objectArray;
        echoGlobal = new HttpsEchoExtension();
        echoVte12 = new HttpsEchoExtension();
        echoVte12Lvte1 = new HttpsEchoExtension();
        echoVte33 = new HttpsEchoExtension();
        objectArray = new ContainerExtension[]{envoyGlobal, envoyVte12, envoyVte12Lvte1, envoyGlobalDisabled, echoGlobal, echoVte12, echoVte12Lvte1, echoVte33};
        containers = new ContainerExtension.Parallel((ContainerExtension[])objectArray);
        objectArray = new HttpsEchoExtension[]{echoGlobal, echoVte12, echoVte12Lvte1, echoVte33};
        allServices = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0010\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u001d\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest$Companion;", "", "()V", "allServices", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoExtension;", "getAllServices", "()Ljava/util/List;", "containers", "Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension$Parallel;", "echoGlobal", "getEchoGlobal", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoExtension;", "echoVte12", "getEchoVte12", "echoVte12Lvte1", "getEchoVte12Lvte1", "echoVte33", "getEchoVte33", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoyGlobal", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "getEnvoyGlobal", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyGlobalDisabled", "getEnvoyGlobalDisabled", "envoyVte12", "getEnvoyVte12", "envoyVte12Lvte1", "getEnvoyVte12Lvte1", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnvoyExtension getEnvoyGlobal() {
            return envoyGlobal;
        }

        @NotNull
        public final EnvoyExtension getEnvoyGlobalDisabled() {
            return envoyGlobalDisabled;
        }

        @NotNull
        public final EnvoyExtension getEnvoyVte12() {
            return envoyVte12;
        }

        @NotNull
        public final EnvoyExtension getEnvoyVte12Lvte1() {
            return envoyVte12Lvte1;
        }

        @NotNull
        public final HttpsEchoExtension getEchoGlobal() {
            return echoGlobal;
        }

        @NotNull
        public final HttpsEchoExtension getEchoVte12() {
            return echoVte12;
        }

        @NotNull
        public final HttpsEchoExtension getEchoVte12Lvte1() {
            return echoVte12Lvte1;
        }

        @NotNull
        public final HttpsEchoExtension getEchoVte33() {
            return echoVte33;
        }

        @NotNull
        public final List<HttpsEchoExtension> getAllServices() {
            return allServices;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0005J(\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0005R!\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest$Extensions;", "", "()V", "consulRegisteredServicesIds", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/ServiceExtension;", "", "getConsulRegisteredServicesIds", "()Ljava/util/Map;", "deregisterInstance", "", "extension", "registerInstance", "name", "tags", "", "envoy-control-tests"})
    @SourceDebugExtension(value={"SMAP\nServiceTagPreferenceTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceTagPreferenceTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest$Extensions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,432:1\n1#2:433\n*E\n"})
    private static final class Extensions {
        @NotNull
        public static final Extensions INSTANCE = new Extensions();
        @NotNull
        private static final Map<ServiceExtension<?>, String> consulRegisteredServicesIds = new LinkedHashMap();

        private Extensions() {
        }

        public final void registerInstance(@NotNull String name, @NotNull List<String> tags, @NotNull ServiceExtension<?> extension) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            Intrinsics.checkNotNullParameter(extension, (String)"extension");
            String id = ConsulOperations.registerService$default(ServiceTagPreferenceTestBase.consul.getServer().getOperations(), extension, null, name, false, tags, null, 42, null);
            consulRegisteredServicesIds.put(extension, id);
        }

        public final void deregisterInstance(@NotNull ServiceExtension<?> extension) {
            Intrinsics.checkNotNullParameter(extension, (String)"extension");
            String removed = consulRegisteredServicesIds.remove(extension);
            if (removed == null) {
                boolean bl = false;
                String string = "Extension was already unregistered!";
                throw new IllegalArgumentException(string.toString());
            }
            ServiceTagPreferenceTestBase.consul.getServer().getOperations().deregisterService(removed);
        }

        @NotNull
        public final Map<ServiceExtension<?>, String> getConsulRegisteredServicesIds() {
            return consulRegisteredServicesIds;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Order(value=2)
    @Nested
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest$ThenLvteInstanceIsDown;", "", "(Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest;)V", "LVTE request falls back to base VTE instance", "", "deregisterLvte", "envoy-control-tests"})
    public final class ThenLvteInstanceIsDown {
        @Test
        public final void LVTE request falls back to base VTE instance() {
            this.deregisterLvte();
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyGlobal(), "echo", null, null, 6, null), Companion.getEchoGlobal());
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyVte12(), "echo", null, null, 6, null), Companion.getEchoVte12());
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyVte12Lvte1(), "echo", null, null, 6, null), Companion.getEchoVte12());
        }

        public final void deregisterLvte() {
            Extensions.INSTANCE.deregisterInstance(Companion.getEchoVte12Lvte1());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Order(value=1)
    @Nested
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest$WhenAllServicesAreUp;", "Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest$WhenAllServicesAreUpSetup;", "(Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest;)V", "preference routing is disabled for selected service", "", "requests are routed according to default service tag preference", "returns 503 when there is no instance fulfilling the preference", "x-service-tag overrides x-service-tag-preference", "x-service-tag-preference from request overrides default one", "x-service-tag-preference is passed upstream", "envoy-control-tests"})
    public final class WhenAllServicesAreUp
    extends WhenAllServicesAreUpSetup {
        @Test
        public final void requests are routed according to default service tag preference() {
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyGlobal(), "echo", null, null, 6, null), Companion.getEchoGlobal());
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyVte12(), "echo", null, null, 6, null), Companion.getEchoVte12());
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyVte12Lvte1(), "echo", null, null, 6, null), Companion.getEchoVte12Lvte1());
        }

        @Test
        public final void x-service-tag-preference from request overrides default one() {
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyGlobal(), "echo", "lvte1|vte12|global", null, 4, null), Companion.getEchoVte12Lvte1());
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyVte12(), "echo", "global", null, 4, null), Companion.getEchoGlobal());
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyVte12(), "echo", "lvte1|vte12|global", null, 4, null), Companion.getEchoVte12Lvte1());
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyVte12Lvte1(), "echo", "vte12|global", null, 4, null), Companion.getEchoVte12());
        }

        @Test
        public final void x-service-tag overrides x-service-tag-preference() {
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyGlobal(), "echo", null, "vte12", 2, null), Companion.getEchoVte12());
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyVte12(), "echo", null, "cz", 2, null), Companion.getEchoVte33());
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTest.this.callServiceRepeatedly(Companion.getEnvoyVte12(), "echo", "lvte1|vte12|global", "global"), Companion.getEchoGlobal());
        }

        @Test
        public final void x-service-tag-preference is passed upstream() {
            HttpsEchoResponse it = HttpsEchoContainerKt.asHttpsEchoResponse(ServiceTagPreferenceTestBase.callService$default(ServiceTagPreferenceTest.this, Companion.getEnvoyGlobal(), "echo", null, null, 6, null));
            boolean bl = false;
            MapAssert cfr_ignored_0 = (MapAssert)Assertions.assertThat(it.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"global");
            it = HttpsEchoContainerKt.asHttpsEchoResponse(ServiceTagPreferenceTestBase.callService$default(ServiceTagPreferenceTest.this, Companion.getEnvoyVte12Lvte1(), "echo", null, null, 6, null));
            boolean bl2 = false;
            MapAssert cfr_ignored_1 = (MapAssert)Assertions.assertThat(it.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"lvte1|vte12|global");
            it = HttpsEchoContainerKt.asHttpsEchoResponse(ServiceTagPreferenceTestBase.callService$default(ServiceTagPreferenceTest.this, Companion.getEnvoyGlobal(), "echo", "vte66|global", null, 4, null));
            boolean bl3 = false;
            MapAssert cfr_ignored_2 = (MapAssert)Assertions.assertThat(it.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"vte66|global");
            it = HttpsEchoContainerKt.asHttpsEchoResponse(ServiceTagPreferenceTestBase.callService$default(ServiceTagPreferenceTest.this, Companion.getEnvoyVte12(), "echo", null, "cz", 2, null));
            boolean bl4 = false;
            MapAssert cfr_ignored_3 = (MapAssert)Assertions.assertThat(it.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"vte12|global");
            it = HttpsEchoContainerKt.asHttpsEchoResponse(ServiceTagPreferenceTest.this.callService(Companion.getEnvoyVte12(), "echo", "lvte1|vte12|global", "cz"));
            boolean bl5 = false;
            MapAssert cfr_ignored_4 = (MapAssert)Assertions.assertThat(it.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"lvte1|vte12|global");
        }

        @Test
        public final void returns 503 when there is no instance fulfilling the preference() {
            Response it = ServiceTagPreferenceTestBase.callService$default(ServiceTagPreferenceTest.this, Companion.getEnvoyGlobal(), "echo", "vte77", null, 4, null);
            boolean bl = false;
            ObjectAssert objectAssert = Assertions.assertThat((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
            ResponseAssertionsKt.isUnreachable((ObjectAssert<Response>)objectAssert);
        }

        @Test
        public final void preference routing is disabled for selected service() {
            ServiceTagPreferenceTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyGlobal(), "echo", null, null, 6, null), Companion.getEchoGlobal());
            ServiceTagPreferenceTestBase.assertResponsesFromRandomInstances$default(ServiceTagPreferenceTest.this, ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceTest.this, Companion.getEnvoyGlobalDisabled(), "echo", null, null, 6, null), null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest$WhenAllServicesAreUpSetup;", "", "()V", "Companion", "envoy-control-tests"})
    public static class WhenAllServicesAreUpSetup {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @JvmStatic
        @BeforeAll
        public static final void registerServices() {
            Companion.registerServices();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest$WhenAllServicesAreUpSetup$Companion;", "", "()V", "registerServices", "", "envoy-control-tests"})
        @SourceDebugExtension(value={"SMAP\nServiceTagPreferenceTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceTagPreferenceTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest$WhenAllServicesAreUpSetup$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,432:1\n1855#2:433\n1855#2,2:434\n1856#2:436\n*S KotlinDebug\n*F\n+ 1 ServiceTagPreferenceTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTest$WhenAllServicesAreUpSetup$Companion\n*L\n70#1:433\n71#1:434,2\n70#1:436\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @BeforeAll
            public final void registerServices() {
                Object[] objectArray = new String[]{"global", "other-1"};
                Extensions.INSTANCE.registerInstance("echo", CollectionsKt.listOf((Object[])objectArray), ServiceTagPreferenceTest.Companion.getEchoGlobal());
                objectArray = new String[]{"vte12", "other-2"};
                Extensions.INSTANCE.registerInstance("echo", CollectionsKt.listOf((Object[])objectArray), ServiceTagPreferenceTest.Companion.getEchoVte12());
                objectArray = new String[]{"lvte1", "other-3"};
                Extensions.INSTANCE.registerInstance("echo", CollectionsKt.listOf((Object[])objectArray), ServiceTagPreferenceTest.Companion.getEchoVte12Lvte1());
                objectArray = new String[]{"vte33", "other-3", "cz"};
                Extensions.INSTANCE.registerInstance("echo", CollectionsKt.listOf((Object[])objectArray), ServiceTagPreferenceTest.Companion.getEchoVte33());
                objectArray = new EnvoyExtension[]{ServiceTagPreferenceTest.Companion.getEnvoyGlobal(), ServiceTagPreferenceTest.Companion.getEnvoyVte12(), ServiceTagPreferenceTest.Companion.getEnvoyVte12Lvte1()};
                Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EnvoyExtension envoy = (EnvoyExtension)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = ServiceTagPreferenceTest.Companion.getAllServices();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        HttpsEchoExtension service = (HttpsEchoExtension)element$iv2;
                        boolean bl2 = false;
                        envoy.waitForClusterEndpointHealthy("echo", service.container().ipAddress());
                    }
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

