/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.routing;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\bf\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u0010H&J\b\u0010\u0011\u001a\u00020\u0012H&J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0014H&J\b\u0010\u0016\u001a\u00020\u0014H&J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H&J\b\u0010\u001a\u001a\u00020\u0018H\u0017J\b\u0010\u001b\u001a\u00020\u0018H\u0017J\b\u0010\u001c\u001a\u00020\u0018H\u0017J\b\u0010\u001d\u001a\u00020\u0018H\u0017J\b\u0010\u001e\u001a\u00020\u0018H\u0017J\b\u0010\u001f\u001a\u00020\u0018H\u0017J\b\u0010 \u001a\u00020\u0018H\u0017J\b\u0010!\u001a\u00020\u0018H\u0017J\b\u0010\"\u001a\u00020\u0018H\u0017J\b\u0010#\u001a\u00020\u0018H\u0017\u00a8\u0006$"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagsTest;", "", "callEchoServiceRepeatedly", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;", "repeat", "", "tag", "", "assertNoErrors", "", "callServiceRepeatedly", "service", "callStats", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "genericService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "loremIpsumService", "loremService", "registerServices", "", "regularService", "should not route request with multiple tags if service is not whitelisted", "should not route request with three tags if combination is not allowed", "should not route request with two tags if combination is not allowed", "should return 503 if instance with requested tag is not found", "should return 503 if requested tag is blacklisted", "should route request with three tags if combination is valid", "should route request with two tags if combination is valid", "should route requests to all instances", "should route requests to instance with tag ipsum", "should route requests to instances with tag lorem", "envoy-control-tests"})
public interface ServiceTagsTest {
    public void registerServices();

    @Test
    public void should route requests to instance with tag ipsum();

    @Test
    public void should route requests to instances with tag lorem();

    @Test
    public void should route requests to all instances();

    @Test
    public void should return 503 if instance with requested tag is not found();

    @Test
    public void should return 503 if requested tag is blacklisted();

    @Test
    public void should route request with three tags if combination is valid();

    @Test
    public void should not route request with multiple tags if service is not whitelisted();

    @Test
    public void should not route request with three tags if combination is not allowed();

    @Test
    public void should route request with two tags if combination is valid();

    @Test
    public void should not route request with two tags if combination is not allowed();

    @NotNull
    public CallStats callEchoServiceRepeatedly(int var1, @Nullable String var2, boolean var3);

    @NotNull
    public CallStats callStats();

    @NotNull
    public CallStats callServiceRepeatedly(@NotNull String var1, int var2, @Nullable String var3, boolean var4);

    @NotNull
    public ConsulExtension consul();

    @NotNull
    public EnvoyControlExtension envoyControl();

    @NotNull
    public EchoServiceExtension regularService();

    @NotNull
    public EchoServiceExtension loremService();

    @NotNull
    public EchoServiceExtension loremIpsumService();

    @NotNull
    public EchoServiceExtension genericService();

    @NotNull
    public EnvoyExtension envoy();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nServiceTagsTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceTagsTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagsTest$DefaultImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n1#2:389\n*E\n"})
    public static final class DefaultImpls {
        public static void registerServices(@NotNull ServiceTagsTest $this) {
            ConsulOperations consulOperations = $this.consul().getServer().getOperations();
            EchoServiceExtension echoServiceExtension = $this.regularService();
            List list = CollectionsKt.emptyList();
            ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
            consulOperations = $this.consul().getServer().getOperations();
            echoServiceExtension = $this.loremService();
            Object[] objectArray = new String[]{"lorem", "blacklisted"};
            list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
            consulOperations = $this.consul().getServer().getOperations();
            echoServiceExtension = $this.loremIpsumService();
            objectArray = new String[]{"lorem", "ipsum"};
            list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        }

        @Test
        public static void should route requests to instance with tag ipsum(@NotNull ServiceTagsTest $this) {
            $this.registerServices();
            String[] stringArray = new String[]{"echo"};
            $this.envoy().waitForReadyServices(stringArray);
            CallStats stats2 = DefaultImpls.callEchoServiceRepeatedly$default($this, 10, "ipsum", false, 4, null);
            Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)stats2.hits($this.regularService())).isEqualTo(0);
            Assertions.assertThat((int)stats2.hits($this.loremService())).isEqualTo(0);
            Assertions.assertThat((int)stats2.hits($this.loremIpsumService())).isEqualTo(10);
        }

        @Test
        public static void should route requests to instances with tag lorem(@NotNull ServiceTagsTest $this) {
            $this.registerServices();
            String[] stringArray = new String[]{"echo"};
            $this.envoy().waitForReadyServices(stringArray);
            CallStats stats2 = DefaultImpls.callEchoServiceRepeatedly$default($this, 20, "lorem", false, 4, null);
            Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(20);
            Assertions.assertThat((int)stats2.hits($this.regularService())).isEqualTo(0);
            Assertions.assertThat((int)stats2.hits($this.loremService())).isGreaterThan(2);
            Assertions.assertThat((int)stats2.hits($this.loremIpsumService())).isGreaterThan(2);
            Assertions.assertThat((int)(stats2.hits($this.loremService()) + stats2.hits($this.loremIpsumService()))).isEqualTo(20);
        }

        @Test
        public static void should route requests to all instances(@NotNull ServiceTagsTest $this) {
            $this.registerServices();
            String[] stringArray = new String[]{"echo"};
            $this.envoy().waitForReadyServices(stringArray);
            CallStats stats2 = DefaultImpls.callEchoServiceRepeatedly$default($this, 20, null, false, 6, null);
            Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(20);
            Assertions.assertThat((int)stats2.hits($this.regularService())).isGreaterThan(1);
            Assertions.assertThat((int)stats2.hits($this.loremService())).isGreaterThan(1);
            Assertions.assertThat((int)stats2.hits($this.loremIpsumService())).isGreaterThan(1);
            Assertions.assertThat((int)(stats2.hits($this.regularService()) + stats2.hits($this.loremService()) + stats2.hits($this.loremIpsumService()))).isEqualTo(20);
        }

        @Test
        public static void should return 503 if instance with requested tag is not found(@NotNull ServiceTagsTest $this) {
            $this.registerServices();
            String[] stringArray = new String[]{"echo"};
            $this.envoy().waitForReadyServices(stringArray);
            CallStats stats2 = $this.callEchoServiceRepeatedly(10, "dolom", false);
            Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)stats2.getFailedHits()).isEqualTo(10);
            Assertions.assertThat((int)stats2.hits($this.regularService())).isEqualTo(0);
            Assertions.assertThat((int)stats2.hits($this.loremService())).isEqualTo(0);
            Assertions.assertThat((int)stats2.hits($this.loremIpsumService())).isEqualTo(0);
        }

        @Test
        public static void should return 503 if requested tag is blacklisted(@NotNull ServiceTagsTest $this) {
            $this.registerServices();
            String[] stringArray = new String[]{"echo"};
            $this.envoy().waitForReadyServices(stringArray);
            CallStats stats2 = $this.callEchoServiceRepeatedly(10, "blacklisted", false);
            Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)stats2.getFailedHits()).isEqualTo(10);
            Assertions.assertThat((int)stats2.hits($this.regularService())).isEqualTo(0);
            Assertions.assertThat((int)stats2.hits($this.loremService())).isEqualTo(0);
            Assertions.assertThat((int)stats2.hits($this.loremIpsumService())).isEqualTo(0);
        }

        @Test
        public static void should route request with three tags if combination is valid(@NotNull ServiceTagsTest $this) {
            EchoServiceExtension matching = $this.loremService();
            EchoServiceExtension notMatching = $this.loremIpsumService();
            String[] stringArray = $this.consul().getServer().getOperations();
            Object[] objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
            List list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default((ConsulOperations)stringArray, matching, null, "service-1", false, list, null, 42, null);
            stringArray = $this.consul().getServer().getOperations();
            objectArray = new String[]{"version:v1.5", "hardware:c64", "role:master"};
            list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default((ConsulOperations)stringArray, notMatching, null, "service-1", false, list, null, 42, null);
            stringArray = new String[]{"service-1"};
            $this.envoy().waitForReadyServices(stringArray);
            CallStats stats2 = DefaultImpls.callServiceRepeatedly$default($this, "service-1", 10, "hardware:c32,role:master,version:v1.5", false, 8, null);
            Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)stats2.hits(matching)).isEqualTo(10);
            Assertions.assertThat((int)stats2.hits(notMatching)).isEqualTo(0);
        }

        @Test
        public static void should not route request with multiple tags if service is not whitelisted(@NotNull ServiceTagsTest $this) {
            EchoServiceExtension matching = $this.loremService();
            String[] stringArray = $this.consul().getServer().getOperations();
            Object[] objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
            List list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default((ConsulOperations)stringArray, matching, null, "service-3", false, list, null, 42, null);
            stringArray = new String[]{"service-3"};
            $this.envoy().waitForReadyServices(stringArray);
            CallStats threeTagsStats = $this.callServiceRepeatedly("service-3", 10, "hardware:c32,role:master,version:v1.5", false);
            CallStats twoTagsStats = $this.callServiceRepeatedly("service-3", 10, "hardware:c32,role:master", false);
            CallStats oneTagStats = DefaultImpls.callServiceRepeatedly$default($this, "service-3", 10, "role:master", false, 8, null);
            Assertions.assertThat((int)threeTagsStats.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)threeTagsStats.getFailedHits()).isEqualTo(10);
            Assertions.assertThat((int)threeTagsStats.hits(matching)).isEqualTo(0);
            Assertions.assertThat((int)twoTagsStats.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)twoTagsStats.getFailedHits()).isEqualTo(10);
            Assertions.assertThat((int)twoTagsStats.hits(matching)).isEqualTo(0);
            Assertions.assertThat((int)oneTagStats.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)oneTagStats.getFailedHits()).isEqualTo(0);
            Assertions.assertThat((int)oneTagStats.hits(matching)).isEqualTo(10);
        }

        @Test
        public static void should not route request with three tags if combination is not allowed(@NotNull ServiceTagsTest $this) {
            EchoServiceExtension service1Matching = $this.loremService();
            EchoServiceExtension service2Matching = $this.loremIpsumService();
            String[] stringArray = $this.consul().getServer().getOperations();
            Object[] objectArray = new String[]{"version:v1.5", "hardware:c32", "ram:512"};
            List list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default((ConsulOperations)stringArray, service1Matching, null, "service-1", false, list, null, 42, null);
            stringArray = $this.consul().getServer().getOperations();
            objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
            list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default((ConsulOperations)stringArray, service2Matching, null, "service-2", false, list, null, 42, null);
            stringArray = new String[]{"service-1", "service-2"};
            $this.envoy().waitForReadyServices(stringArray);
            CallStats service1Stats = $this.callServiceRepeatedly("service-1", 10, "hardware:c32,ram:512,version:v1.5", false);
            CallStats service2Stats = $this.callServiceRepeatedly("service-2", 10, "hardware:c32,role:master,version:v1.5", false);
            Assertions.assertThat((int)service1Stats.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)service1Stats.getFailedHits()).isEqualTo(10);
            Assertions.assertThat((int)service1Stats.hits(service1Matching)).isEqualTo(0);
            Assertions.assertThat((int)service2Stats.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)service2Stats.getFailedHits()).isEqualTo(10);
            Assertions.assertThat((int)service2Stats.hits(service1Matching)).isEqualTo(0);
        }

        @Test
        public static void should route request with two tags if combination is valid(@NotNull ServiceTagsTest $this) {
            EchoServiceExtension service1Matching = $this.loremService();
            EchoServiceExtension service1NotMatching = $this.regularService();
            EchoServiceExtension service2Master = $this.loremIpsumService();
            EchoServiceExtension service2Secondary = $this.genericService();
            String[] stringArray = $this.consul().getServer().getOperations();
            Object[] objectArray = new String[]{"version:v2.0", "hardware:c32", "role:master"};
            List list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default((ConsulOperations)stringArray, service1Matching, null, "service-1", false, list, null, 42, null);
            stringArray = $this.consul().getServer().getOperations();
            objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
            list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default((ConsulOperations)stringArray, service1NotMatching, null, "service-1", false, list, null, 42, null);
            stringArray = $this.consul().getServer().getOperations();
            objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
            list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default((ConsulOperations)stringArray, service2Master, null, "service-2", false, list, null, 42, null);
            stringArray = $this.consul().getServer().getOperations();
            objectArray = new String[]{"version:v2.0", "hardware:c32", "role:secondary"};
            list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default((ConsulOperations)stringArray, service2Secondary, null, "service-2", false, list, null, 42, null);
            stringArray = new String[]{"service-1", "service-2"};
            $this.envoy().waitForReadyServices(stringArray);
            CallStats service1Stats = DefaultImpls.callServiceRepeatedly$default($this, "service-1", 10, "hardware:c32,version:v2.0", false, 8, null);
            CallStats service2MasterStats = DefaultImpls.callServiceRepeatedly$default($this, "service-2", 10, "hardware:c32,version:v1.5", false, 8, null);
            CallStats service2SecondaryStats = DefaultImpls.callServiceRepeatedly$default($this, "service-2", 10, "role:secondary,version:v2.0", false, 8, null);
            Assertions.assertThat((int)service1Stats.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)service1Stats.hits(service1Matching)).isEqualTo(10);
            Assertions.assertThat((int)service2MasterStats.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)service2MasterStats.hits(service2Master)).isEqualTo(10);
            Assertions.assertThat((int)service2SecondaryStats.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)service2SecondaryStats.hits(service2Secondary)).isEqualTo(10);
        }

        @Test
        public static void should not route request with two tags if combination is not allowed(@NotNull ServiceTagsTest $this) {
            EchoServiceExtension matching = $this.loremService();
            String[] stringArray = $this.consul().getServer().getOperations();
            Object[] objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
            List list = CollectionsKt.listOf((Object[])objectArray);
            ConsulOperations.registerService$default((ConsulOperations)stringArray, matching, null, "service-2", false, list, null, 42, null);
            stringArray = new String[]{"service-2"};
            $this.envoy().waitForReadyServices(stringArray);
            CallStats stats2 = $this.callServiceRepeatedly("service-2", 10, "hardware:c32,role:master", false);
            Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
            Assertions.assertThat((int)stats2.getFailedHits()).isEqualTo(10);
            Assertions.assertThat((int)stats2.hits(matching)).isEqualTo(0);
        }

        @NotNull
        public static CallStats callEchoServiceRepeatedly(@NotNull ServiceTagsTest $this, int repeat, @Nullable String tag, boolean assertNoErrors) {
            return $this.callServiceRepeatedly("echo", repeat, tag, assertNoErrors);
        }

        public static /* synthetic */ CallStats callEchoServiceRepeatedly$default(ServiceTagsTest serviceTagsTest, int n, String string, boolean bl, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callEchoServiceRepeatedly");
            }
            if ((n2 & 2) != 0) {
                string = null;
            }
            if ((n2 & 4) != 0) {
                bl = true;
            }
            return serviceTagsTest.callEchoServiceRepeatedly(n, string, bl);
        }

        @NotNull
        public static CallStats callStats(@NotNull ServiceTagsTest $this) {
            Object[] objectArray = new EchoServiceExtension[]{$this.regularService(), $this.loremService(), $this.loremIpsumService(), $this.genericService()};
            return new CallStats(CollectionsKt.listOf((Object[])objectArray));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static CallStats callServiceRepeatedly(@NotNull ServiceTagsTest $this, @NotNull String service, int repeat, @Nullable String tag, boolean assertNoErrors) {
            Object object;
            Function1 function1;
            int n;
            int n2;
            CallStats callStats;
            String string;
            EgressOperations egressOperations;
            CallStats stats2;
            block3: {
                block2: {
                    void it;
                    Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                    stats2 = $this.callStats();
                    egressOperations = $this.envoy().getEgressOperations();
                    string = service;
                    callStats = stats2;
                    n2 = repeat;
                    n = repeat;
                    function1 = null;
                    object = tag;
                    if (object == null) break block2;
                    String string2 = object;
                    Function1 function12 = function1;
                    int n3 = n;
                    int n4 = n2;
                    CallStats callStats2 = callStats;
                    String string3 = string;
                    EgressOperations egressOperations2 = egressOperations;
                    boolean bl = false;
                    Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-tag", (Object)it));
                    egressOperations = egressOperations2;
                    string = string3;
                    callStats = callStats2;
                    n2 = n4;
                    n = n3;
                    function1 = function12;
                    Map map2 = map;
                    object = map2;
                    if (map2 != null) break block3;
                }
                object = MapsKt.emptyMap();
            }
            EgressOperations.callServiceRepeatedly$default(egressOperations, string, callStats, n2, n, function1, (Map)object, null, assertNoErrors, 80, null);
            return stats2;
        }

        public static /* synthetic */ CallStats callServiceRepeatedly$default(ServiceTagsTest serviceTagsTest, String string, int n, String string2, boolean bl, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callServiceRepeatedly");
            }
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            if ((n2 & 8) != 0) {
                bl = true;
            }
            return serviceTagsTest.callServiceRepeatedly(string, n, string2, bl);
        }
    }
}

