/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.routing;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J3\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\b0\fH\u0004J$\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0004R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/TestBase;", "", "echoService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/ServiceExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/service/ServiceExtension;Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;)V", "upstreamServiceTagsInResponseTest", "", "service", "", "assertions", "Lkotlin/Function1;", "Lokhttp3/Response;", "Lkotlin/ParameterName;", "name", "echoResponse", "waitForEndpointReady", "serviceName", "serviceInstance", "Companion", "envoy-control-tests"})
public abstract class TestBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServiceExtension<?> echoService;
    @NotNull
    private final EnvoyExtension envoy;
    @NotNull
    private static final String proxySettings = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        routingPolicy:\n          autoServiceTag: true\n          serviceTagPreference: [\"ipsum\", \"lorem\"]\n          fallbackToAnyInstance: true\n        dependencies:\n          - service: \"echo\" \n          - service: \"echo-disabled\"\n            routingPolicy:\n              autoServiceTag: false\n          - service: \"echo-one-tag\"  \n            routingPolicy:\n              serviceTagPreference: [\"one\"]\n          - service: \"echo-no-tag\"  \n            routingPolicy:\n              serviceTagPreference: []";
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension(false, 1, null);
    @NotNull
    private static final List<String> allTags;

    public TestBase(@NotNull ServiceExtension<?> echoService, @NotNull EnvoyExtension envoy) {
        Intrinsics.checkNotNullParameter(echoService, (String)"echoService");
        Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
        this.echoService = echoService;
        this.envoy = envoy;
    }

    protected final void upstreamServiceTagsInResponseTest(@NotNull String service, @NotNull Function1<? super Response, Unit> assertions) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(assertions, (String)"assertions");
        ConsulOperations consulOperations = consul.getServer().getOperations();
        ServiceExtension<?> serviceExtension = this.echoService;
        List<String> list = allTags;
        ConsulOperations.registerService$default(consulOperations, serviceExtension, null, service, false, list, null, 42, null);
        this.waitForEndpointReady(service, this.echoService, this.envoy);
        Response echoResponse = EgressOperations.callService$default(this.envoy.getEgressOperations(), service, null, null, null, null, 30, null);
        assertions.invoke((Object)echoResponse);
    }

    protected final void waitForEndpointReady(@NotNull String serviceName, @NotNull ServiceExtension<?> serviceInstance, @NotNull EnvoyExtension envoy) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter(serviceInstance, (String)"serviceInstance");
        Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
        envoy.waitForClusterEndpointHealthy(serviceName, serviceInstance.container().ipAddress());
    }

    static {
        Object[] objectArray = new String[]{"ipsum", "lorem", "one"};
        allTags = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/TestBase$Companion;", "", "()V", "allTags", "", "", "getAllTags", "()Ljava/util/List;", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "proxySettings", "getProxySettings", "()Ljava/lang/String;", "properties", "", "", "addUpstreamServiceTagsHeader", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Boolean> properties(boolean addUpstreamServiceTagsHeader) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.auto-service-tag-enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.add-upstream-service-tags-header", (Object)addUpstreamServiceTagsHeader)};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        public static /* synthetic */ Map properties$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.properties(bl);
        }

        @NotNull
        public final String getProxySettings() {
            return proxySettings;
        }

        @NotNull
        public final List<String> getAllTags() {
            return allTags;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

