/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.trafficsplitting;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulMultiClusterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlClusteredExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.trafficsplitting.LocalityWeightedLoadBalancingTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/trafficsplitting/LocalityWeightedLoadBalancingTest;", "", "()V", "should not split traffic from unlisted zone", "", "should route traffic according to weights", "should route traffic according to weights with service tag", "Companion", "envoy-control-tests"})
public final class LocalityWeightedLoadBalancingTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, Object> properties;
    @NotNull
    private static final String echo2Config;
    @NotNull
    private static final EnvoyConfig config;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulMultiClusterExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControl2;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControl3;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoServiceDC1;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension upstreamServiceDC1;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension upstreamServiceDC2;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension upstreamServiceDC3;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension downstreamServiceEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyDC2;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyDC3;

    @Test
    public final void should route traffic according to weights() {
        ConsulOperations.registerServiceWithEnvoyOnEgress$default(consul.getServerFirst().getOperations(), downstreamServiceEnvoy, null, "echo2", false, null, 26, null);
        ConsulOperations.registerService$default(consul.getServerFirst().getOperations(), upstreamServiceDC1, null, "service-1", false, null, null, 58, null);
        TrafficSplittingKt.verifyIsReachable(downstreamServiceEnvoy, upstreamServiceDC1, "service-1");
        ConsulOperations.registerService$default(consul.getServerSecond().getOperations(), upstreamServiceDC2, null, "service-1", false, null, null, 58, null);
        TrafficSplittingKt.verifyIsReachable(downstreamServiceEnvoy, upstreamServiceDC2, "service-1");
        EchoServiceExtension[] echoServiceExtensionArray = new EchoServiceExtension[]{upstreamServiceDC1, upstreamServiceDC2};
        TrafficSplittingKt.verifyCallsCountEq(TrafficSplittingKt.verifyCallsCountCloseTo(TrafficSplittingKt.verifyCallsCountCloseTo(TrafficSplittingKt.callUpstreamServiceRepeatedly$default(downstreamServiceEnvoy, echoServiceExtensionArray, 0, 2, null), upstreamServiceDC1, 75), upstreamServiceDC2, 25), upstreamServiceDC3, 0);
    }

    @Test
    public final void should route traffic according to weights with service tag() {
        ConsulOperations.registerServiceWithEnvoyOnEgress$default(consul.getServerFirst().getOperations(), downstreamServiceEnvoy, null, "echo2", false, null, 26, null);
        ConsulOperations.registerService$default(consul.getServerFirst().getOperations(), upstreamServiceDC1, null, "service-1", false, CollectionsKt.listOf((Object)"tag"), null, 42, null);
        TrafficSplittingKt.verifyIsReachable(downstreamServiceEnvoy, upstreamServiceDC1, "service-1");
        ConsulOperations.registerService$default(consul.getServerSecond().getOperations(), upstreamServiceDC2, null, "service-1", false, CollectionsKt.listOf((Object)"tag"), null, 42, null);
        TrafficSplittingKt.verifyIsReachable(downstreamServiceEnvoy, upstreamServiceDC2, "service-1");
        EchoServiceExtension[] echoServiceExtensionArray = new EchoServiceExtension[]{upstreamServiceDC1, upstreamServiceDC2};
        TrafficSplittingKt.verifyCallsCountEq(TrafficSplittingKt.verifyCallsCountCloseTo(TrafficSplittingKt.verifyCallsCountCloseTo(TrafficSplittingKt.callUpstreamServiceRepeatedly$default(downstreamServiceEnvoy, echoServiceExtensionArray, 0, "tag", 2, null), upstreamServiceDC1, 75), upstreamServiceDC2, 25), upstreamServiceDC3, 0);
    }

    @Test
    public final void should not split traffic from unlisted zone() {
        ConsulOperations.registerServiceWithEnvoyOnEgress$default(consul.getServerThird().getOperations(), envoyDC3, null, "echo", false, null, 26, null);
        ConsulOperations.registerService$default(consul.getServerThird().getOperations(), upstreamServiceDC3, null, "service-1", false, null, null, 58, null);
        TrafficSplittingKt.verifyIsReachable(envoyDC3, upstreamServiceDC3, "service-1");
        ConsulOperations.registerService$default(consul.getServerSecond().getOperations(), upstreamServiceDC2, null, "service-1", false, null, null, 58, null);
        TrafficSplittingKt.verifyIsReachable(envoyDC2, upstreamServiceDC2, "service-1");
        EchoServiceExtension[] echoServiceExtensionArray = new EchoServiceExtension[]{upstreamServiceDC3, upstreamServiceDC2};
        TrafficSplittingKt.verifyCallsCountEq(TrafficSplittingKt.verifyCallsCountEq(TrafficSplittingKt.verifyCallsCountEq(TrafficSplittingKt.callUpstreamServiceRepeatedly$default(envoyDC3, echoServiceExtensionArray, 0, 2, null), upstreamServiceDC3, 100), upstreamServiceDC2, 0), upstreamServiceDC1, 0);
    }

    public static final /* synthetic */ Map access$getProperties$cp() {
        return properties;
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.stateSampleDuration", (Object)Duration.ZERO), TuplesKt.to((Object)"envoy-control.sync.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.loadBalancing.trafficSplitting.zoneName", (Object)"dc2"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.loadBalancing.trafficSplitting.zonesAllowingTrafficSplitting", (Object)CollectionsKt.listOf((Object)"dc1")), TuplesKt.to((Object)"envoy-control.envoy.snapshot.loadBalancing.trafficSplitting.weightsByService.echo2.weightByZone.dc1", (Object)30), TuplesKt.to((Object)"envoy-control.envoy.snapshot.loadBalancing.trafficSplitting.weightsByService.echo2.weightByZone.dc2", (Object)10), TuplesKt.to((Object)"envoy-control.envoy.snapshot.loadBalancing.trafficSplitting.weightsByService.echo2.weightByZone.dc3", (Object)1), TuplesKt.to((Object)"envoy-control.envoy.snapshot.loadBalancing.priorities.zonePriorities", TrafficSplitting.INSTANCE.getDEFAULT_PRIORITIES())};
        properties = MapsKt.mapOf((Pair[])object);
        echo2Config = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"service-1\"\n          - service: \"service-2\"";
        object = EnvoyControlTestConfigurationKt.getXds();
        String string = echo2Config;
        config = EnvoyConfig.copy$default((EnvoyConfig)object, null, "echo2", string, null, null, null, 57, null);
        consul = new ConsulMultiClusterExtension();
        envoyControl = new EnvoyControlClusteredExtension(consul.getServerFirst(), (Function0<? extends Map<String, ? extends Object>>)((Function0)Companion.envoyControl.1.INSTANCE), (List<? extends BeforeAllCallback>)CollectionsKt.listOf((Object)consul));
        envoyControl2 = new EnvoyControlClusteredExtension(consul.getServerSecond(), (Function0<? extends Map<String, ? extends Object>>)((Function0)Companion.envoyControl2.1.INSTANCE), (List<? extends BeforeAllCallback>)CollectionsKt.listOf((Object)consul));
        envoyControl3 = new EnvoyControlClusteredExtension(consul.getServerThird(), (Function0<? extends Map<String, ? extends Object>>)((Function0)Companion.envoyControl3.1.INSTANCE), (List<? extends BeforeAllCallback>)CollectionsKt.listOf((Object)consul));
        echoServiceDC1 = new EchoServiceExtension();
        upstreamServiceDC1 = new EchoServiceExtension();
        upstreamServiceDC2 = new EchoServiceExtension();
        upstreamServiceDC3 = new EchoServiceExtension();
        downstreamServiceEnvoy = new EnvoyExtension(envoyControl, echoServiceDC1, config, null, 8, null);
        envoyDC2 = new EnvoyExtension(envoyControl2, null, null, null, 14, null);
        envoyDC3 = new EnvoyExtension(envoyControl3, null, null, null, 14, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00010\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/trafficsplitting/LocalityWeightedLoadBalancingTest$Companion;", "", "()V", "config", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulMultiClusterExtension;", "downstreamServiceEnvoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echo2Config", "", "echoServiceDC1", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlClusteredExtension;", "envoyControl2", "envoyControl3", "envoyDC2", "envoyDC3", "properties", "", "kotlin.jvm.PlatformType", "upstreamServiceDC1", "upstreamServiceDC2", "upstreamServiceDC3", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

