// Generated by delombok at Fri Aug 03 10:52:24 UTC 2018
/**
 * This file is part of the ChillDev-Commons.
 *
 * @license http://mit-license.org/ The MIT license
 * @copyright 2018 © by Rafał Wrzeszcz - Wrzasq.pl.
 */
package pl.chilldev.commons.aws.cloudformation;

/**
 * Wrapper for custom resource output type.
 *
 * @param <OutputType> Structure of custom resource returner properties.
 */
public class CustomResourceResponse<OutputType> {
    /**
     * Response data.
     */
    private OutputType data;
    /**
     * Managed resource resource ID.
     */
    private String physicalResourceId;

    /**
     * Initializes new response to ephemeral resources (identified by current Lambda invocation log stream).
     *
     * @param data Response data.
     */
    public CustomResourceResponse(OutputType data) {
        this(data, null);
    }

    /**
     * Response data.
     */
    @SuppressWarnings("all")
    public OutputType getData() {
        return this.data;
    }

    /**
     * Managed resource resource ID.
     */
    @SuppressWarnings("all")
    public String getPhysicalResourceId() {
        return this.physicalResourceId;
    }

    /**
     * Response data.
     */
    @SuppressWarnings("all")
    public void setData(final OutputType data) {
        this.data = data;
    }

    /**
     * Managed resource resource ID.
     */
    @SuppressWarnings("all")
    public void setPhysicalResourceId(final String physicalResourceId) {
        this.physicalResourceId = physicalResourceId;
    }

    @Override
    @SuppressWarnings("all")
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof CustomResourceResponse)) return false;
        final CustomResourceResponse<?> other = (CustomResourceResponse<?>) o;
        if (!other.canEqual((Object) this)) return false;
        final Object this$data = this.getData();
        final Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
        final Object this$physicalResourceId = this.getPhysicalResourceId();
        final Object other$physicalResourceId = other.getPhysicalResourceId();
        if (this$physicalResourceId == null ? other$physicalResourceId != null : !this$physicalResourceId.equals(other$physicalResourceId)) return false;
        return true;
    }

    @SuppressWarnings("all")
    protected boolean canEqual(final Object other) {
        return other instanceof CustomResourceResponse;
    }

    @Override
    @SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $data = this.getData();
        result = result * PRIME + ($data == null ? 43 : $data.hashCode());
        final Object $physicalResourceId = this.getPhysicalResourceId();
        result = result * PRIME + ($physicalResourceId == null ? 43 : $physicalResourceId.hashCode());
        return result;
    }

    @Override
    @SuppressWarnings("all")
    public String toString() {
        return "CustomResourceResponse(data=" + this.getData() + ", physicalResourceId=" + this.getPhysicalResourceId() + ")";
    }

    @SuppressWarnings("all")
    public CustomResourceResponse(final OutputType data, final String physicalResourceId) {
        this.data = data;
        this.physicalResourceId = physicalResourceId;
    }
}
