/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.aws.cloudformation;

import com.amazonaws.services.lambda.runtime.Context;
import com.sunrun.cfnresponse.CfnRequest;
import com.sunrun.cfnresponse.CfnResponseSender;
import com.sunrun.cfnresponse.Status;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.aws.cloudformation.CustomResourceResponse;

public class CustomResourceHandler<InputType, OutputType> {
    private Logger logger = LoggerFactory.getLogger(CustomResourceHandler.class);
    private CfnResponseSender sender = new CfnResponseSender();
    private Map<String, Function<InputType, CustomResourceResponse<OutputType>>> actions = new HashMap<String, Function<InputType, CustomResourceResponse<OutputType>>>();

    public CustomResourceHandler(Function<InputType, CustomResourceResponse<OutputType>> createAction, Function<InputType, CustomResourceResponse<OutputType>> updateAction, Function<InputType, CustomResourceResponse<OutputType>> deleteAction) {
        this.actions.put("Create", createAction);
        this.actions.put("Update", updateAction);
        this.actions.put("Delete", deleteAction);
    }

    public void handle(CfnRequest<InputType> request, Context context) {
        this.logger.info("Incoming CloudFormation request {}: {} -> {} {} (response URL: {}).", new Object[]{request.getRequestId(), request.getStackId(), request.getRequestType(), request.getLogicalResourceId(), request.getResponseURL()});
        try {
            CustomResourceResponse<OutputType> response = this.actions.get(request.getRequestType()).apply(request.getResourceProperties());
            this.sender.send(request, Status.SUCCESS, context, "OK", response.getData(), response.getPhysicalResourceId());
        }
        catch (Exception error) {
            this.logger.error("Failed to handle resource action.", (Throwable)error);
            this.sender.send(request, Status.FAILED, context, error.getMessage(), null, null);
        }
    }
}

