// Generated by delombok at Sat Nov 04 15:55:42 UTC 2017
/**
 * This file is part of the ChillDev-Commons.
 *
 * @license http://mit-license.org/ The MIT license
 * @copyright 2017 © by Rafał Wrzeszcz - Wrzasq.pl.
 */
package pl.chilldev.commons.client.interceptor;

import javax.servlet.http.HttpServletRequest;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.web.context.annotation.RequestScope;

/**
 * Feign request interceptor that forwards HTTP Authorization header downstream.
 */
@Service
@RequestScope
public class AuthorizationForwarder implements RequestInterceptor {
    /**
     * Current HTTP upstream request.
     */
    @Autowired
    private HttpServletRequest request;

    /**
     * {@inheritDoc}
     */
    @Override
    public void apply(RequestTemplate requestTemplate) {
        // do not override header if already explicitly specified
        if (!requestTemplate.headers().containsKey(HttpHeaders.AUTHORIZATION)) {
            // set the same value as incoming request to execute requests on behalf of the user
            requestTemplate.header(HttpHeaders.AUTHORIZATION, this.request.getHeader(HttpHeaders.AUTHORIZATION));
        }
    }

    /**
     * Current HTTP upstream request.
     */
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public void setRequest(final HttpServletRequest request) {
        this.request = request;
    }
}
