/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.client;

import feign.Feign;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class FeignClientFactory {
    private Collection<Consumer<Feign.Builder>> configurators;
    private Supplier<Feign.Builder> feignBuilderSource;

    public FeignClientFactory(Collection<Consumer<Feign.Builder>> configurators, Supplier<Feign.Builder> feignBuilderSource) {
        this.configurators = configurators;
        this.feignBuilderSource = feignBuilderSource;
    }

    public <ClientType> ClientType createClient(Class<? extends ClientType> clientType, String url, Collection<Consumer<Feign.Builder>> configurators) {
        Feign.Builder builder = this.feignBuilderSource.get();
        this.configurators.forEach(configurator -> configurator.accept(builder));
        configurators.forEach(configurator -> configurator.accept(builder));
        return (ClientType)builder.target(clientType, url);
    }

    public <ClientType> ClientType createClient(Class<? extends ClientType> clientType, String url) {
        return this.createClient(clientType, url, Collections.emptyList());
    }
}

