// Generated by delombok at Wed Jun 06 18:24:57 UTC 2018
/**
 * This file is part of the ChillDev-Commons.
 *
 * @license http://mit-license.org/ The MIT license
 * @copyright 2017 © by Rafał Wrzeszcz - Wrzasq.pl.
 */
package pl.chilldev.commons.client.interceptor;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.http.HttpHeaders;

/**
 * Feign request interceptor that injects custom HTTP authorization with Bearer token.
 */
public class BearerTokenAuthorizer implements RequestInterceptor {
    /**
     * Bearer token prefix.
     */
    private static final String TYPE_BEARER = "Bearer ";
    /**
     * HTTP access token..
     */
    private String token;

    /**
     * {@inheritDoc}
     */
    @Override
    public void apply(RequestTemplate requestTemplate) {
        // set the same value as incoming request to execute requests on behalf of the user
        requestTemplate.header(HttpHeaders.AUTHORIZATION, BearerTokenAuthorizer.TYPE_BEARER + this.token);
    }

    @SuppressWarnings("all")
    public BearerTokenAuthorizer(final String token) {
        this.token = token;
    }
}
