/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.client.codec;

import feign.RequestTemplate;
import feign.codec.Encoder;
import java.lang.reflect.Type;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import pl.chilldev.commons.data.ConvertUtils;

public class SpringDataEncoder
implements Encoder {
    private static final String DEFAULT_PARAM_PAGE = "page";
    private static final String DEFAULT_PARAM_SIZE = "size";
    private static final String DEFAULT_PARAM_SORT = "sort";
    private Encoder fallback;
    private String paramPage;
    private String paramSize;
    private String paramSort;

    public SpringDataEncoder(Encoder fallback, String paramPage, String paramSize, String paramSort) {
        this.fallback = fallback;
        this.paramPage = paramPage;
        this.paramSize = paramSize;
        this.paramSort = paramSort;
    }

    public SpringDataEncoder(Encoder fallback) {
        this(fallback, DEFAULT_PARAM_PAGE, DEFAULT_PARAM_SIZE, DEFAULT_PARAM_SORT);
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) {
        if (object instanceof Pageable) {
            Pageable request = (Pageable)object;
            template.query(this.paramPage, new String[]{String.valueOf(request.getPageNumber())}).query(this.paramSize, new String[]{String.valueOf(request.getPageSize())}).query(this.paramSort, (Iterable)ConvertUtils.extractSort((Sort)request.getSort()));
        } else {
            this.fallback.encode(object, bodyType, template);
        }
    }
}

