/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.client.codec;

import feign.Response;
import feign.codec.ErrorDecoder;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public class SpringErrorDecoder
implements ErrorDecoder {
    private ErrorDecoder fallback;

    public SpringErrorDecoder(ErrorDecoder fallback) {
        this.fallback = fallback;
    }

    public Exception decode(String methodKey, Response response) {
        HttpStatus status = HttpStatus.valueOf((int)response.status());
        if (status.is5xxServerError()) {
            return new HttpServerErrorException(status, response.reason());
        }
        if (status.is4xxClientError()) {
            return new HttpClientErrorException(status, response.reason());
        }
        return this.fallback.decode(methodKey, response);
    }
}

