/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.collections.pageable;

import java.util.Iterator;
import java.util.function.Function;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;

public class PageableIterator<Type>
implements Iterator<Type> {
    private Slice<? extends Type> page;
    private Iterator<? extends Type> data;
    private Function<Pageable, Slice<? extends Type>> source;

    public PageableIterator(Slice<? extends Type> page, Function<Pageable, Slice<? extends Type>> source) {
        this.source = source;
        this.handlePage(page);
    }

    private void handlePage(Slice<? extends Type> page) {
        this.page = page;
        this.data = page.getContent().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.data.hasNext() || this.page.hasNext();
    }

    @Override
    public Type next() {
        if (!this.data.hasNext()) {
            this.handlePage(this.source.apply(this.page.nextPageable()));
        }
        return this.data.next();
    }
}

