/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.concurrent.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageBag
implements Serializable {
    protected Map<String, List<Message>> messages = new HashMap<String, List<Message>>();

    public synchronized void addMessage(String type, String message) {
        this.ensureExists(type);
        this.messages.get(type).add(new Message(message));
    }

    public synchronized boolean hasMessages() {
        for (List<Message> list : this.messages.values()) {
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasMessages(String type) {
        this.ensureExists(type);
        return !this.messages.get(type).isEmpty();
    }

    public synchronized List<Message> getMessages(String type) {
        this.ensureExists(type);
        ArrayList<Message> messages = new ArrayList<Message>((Collection)this.messages.get(type));
        this.messages.get(type).clear();
        return messages;
    }

    public synchronized Map<String, List<Message>> getAllMessages() {
        HashMap<String, List<Message>> messages = new HashMap<String, List<Message>>();
        for (Map.Entry<String, List<Message>> entry : this.messages.entrySet()) {
            ArrayList list = new ArrayList(entry.getValue());
            entry.getValue().clear();
            messages.put(entry.getKey(), list);
        }
        return messages;
    }

    protected void ensureExists(String type) {
        if (!this.messages.containsKey(type)) {
            this.messages.put(type, new ArrayList());
        }
    }

    public static class Message
    implements Serializable {
        protected String content;
        protected Date createdAt = new Date();

        public Message(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }
    }
}

