/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.concurrent.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageBag
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, List<Message>> messages = new HashMap<String, List<Message>>();

    public synchronized void addMessage(String type, String message) {
        this.ensureExists(type).add(new Message(message));
    }

    public synchronized boolean hasMessages() {
        for (List<Message> list : this.messages.values()) {
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasMessages(String type) {
        return !this.ensureExists(type).isEmpty();
    }

    public synchronized List<Message> getMessages(String type) {
        List<Message> container = this.ensureExists(type);
        ArrayList<Message> messages = new ArrayList<Message>(container);
        container.clear();
        return messages;
    }

    public synchronized Map<String, List<Message>> getAllMessages() {
        HashMap<String, List<Message>> messages = new HashMap<String, List<Message>>();
        for (Map.Entry<String, List<Message>> entry : this.messages.entrySet()) {
            ArrayList list = new ArrayList(entry.getValue());
            entry.getValue().clear();
            messages.put(entry.getKey(), list);
        }
        return messages;
    }

    protected List<Message> ensureExists(String type) {
        return this.messages.computeIfAbsent(type, key -> new ArrayList());
    }

    public static class Message
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected String content;
        protected Date createdAt = new Date();

        public Message(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public Date getCreatedAt() {
            return (Date)this.createdAt.clone();
        }
    }
}

