/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.daemon.lifecycle;

import org.apache.commons.daemon.Daemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.exception.ExceptionFormatter;

public class Shutdown
extends Thread {
    protected Logger logger = LoggerFactory.getLogger(Shutdown.class);
    protected Daemon daemon;
    protected ExceptionFormatter exceptionFormatter = ExceptionFormatter.SIMPLE_FORMAT;

    public Shutdown(Daemon daemon) {
        this.daemon = daemon;
    }

    public void setExceptionFormatter(ExceptionFormatter exceptionFormatter) {
        this.exceptionFormatter = exceptionFormatter;
    }

    @Override
    public void run() {
        try {
            this.daemon.stop();
            this.daemon.destroy();
            this.logger.trace("Good bye!");
        }
        catch (Throwable error) {
            this.logger.error("Error while stopping dameon {}.", (Object)this.exceptionFormatter.format(error), (Object)error);
        }
    }
}

