/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.daemon;

import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonUserSignal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.daemon.Package;

public abstract class AbstractDaemon
implements Daemon,
DaemonUserSignal {
    protected Logger logger = LoggerFactory.getLogger(AbstractDaemon.class);

    public void signal() {
        this.logger.info("Handling configuration reload.");
        try {
            this.stop();
            this.start();
        }
        catch (Exception error) {
            this.logger.error("Failed to handle signal call.", (Throwable)error);
            throw new RuntimeException(error);
        }
    }

    public void init(DaemonContext context) {
        this.logger.info("Started {} daemon v.{} on {} {} ({}) / Java {} ({}).", new Object[]{this.getClass().getPackage().getName(), Package.DEFAULT_PACKAGE.getVersion(), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.version"), System.getProperty("java.vendor")});
    }

    public void destroy() {
    }
}

