/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.daemon;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class Package {
    public static final String PROPERTY_VERSION = "application.version";
    public static final String DEFAULT_RESOURCE = "/META-INF/application.properties";
    public static final Package DEFAULT_PACKAGE = new Package();
    private String version;

    public void init() {
        this.init(Package.class.getResource(DEFAULT_RESOURCE));
    }

    public void init(URL url) {
        this.version = "devel";
        if (url != null) {
            try (InputStream stream = url.openStream();){
                this.init(stream);
            }
            catch (IOException error) {
                this.version = "error";
            }
        }
    }

    protected void init(InputStream stream) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        this.version = properties.getProperty(PROPERTY_VERSION);
    }

    public synchronized String getVersion() {
        if (this.version == null) {
            this.init();
        }
        return this.version;
    }
}

