/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.db.timestampable;

import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import pl.chilldev.commons.db.timestampable.Timestamp;
import pl.chilldev.commons.db.timestampable.TimestampType;

public class TimestampableListener {
    protected void generateTimestamps(Object timestampable, TimestampType timestampType) throws IllegalAccessException {
        Class<?> type = timestampable.getClass();
        for (Field field : FieldUtils.getAllFields(type)) {
            Timestamp options;
            if (!field.isAnnotationPresent(Timestamp.class) || !ArrayUtils.contains((Object[])(options = field.getDeclaredAnnotation(Timestamp.class)).value(), (Object)((Object)timestampType))) continue;
            FieldUtils.writeField((Object)timestampable, (String)field.getName(), (Object)OffsetDateTime.now(), (boolean)true);
        }
    }

    @PrePersist
    public void createTimestamps(Object timestampable) throws IllegalAccessException {
        this.generateTimestamps(timestampable, TimestampType.CREATE);
    }

    @PreUpdate
    public void updateTimestamps(Object timestampable) throws IllegalAccessException {
        this.generateTimestamps(timestampable, TimestampType.UPDATE);
    }
}

