// Generated by delombok at Tue Mar 20 14:30:02 UTC 2018
/**
 * This file is part of the ChillDev-Commons.
 *
 * @license http://mit-license.org/ The MIT license
 * @copyright 2015 - 2016 © by Rafał Wrzeszcz - Wrzasq.pl.
 */
package pl.chilldev.commons.db;

import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.hibernate.annotations.GenericGenerator;

/**
 * Core entity features.
 */
@MappedSuperclass
public abstract class AbstractEntity {
    /**
     * UUID field length.
     */
    public static final int LENGTH_UUID = 16;
    /**
     * Regular string field length.
     */
    public static final int LENGTH_STRING_STANDARD = 255;
    /**
     * Compact string field length.
     */
    public static final int LENGTH_STRING_COMPACT = 128;
    /**
     * URL field length.
     */
    public static final int LENGTH_URL = 1024;
    /**
     * Record unique identifier.
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "uuid2")
    @Column(length = AbstractEntity.LENGTH_UUID)
    private UUID id;

    /**
     * Record unique identifier.
     */
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public UUID getId() {
        return this.id;
    }

    /**
     * Record unique identifier.
     * @return this
     */
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public AbstractEntity setId(final UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof AbstractEntity)) return false;
        final AbstractEntity other = (AbstractEntity) o;
        if (!other.canEqual((Object) this)) return false;
        final Object this$id = this.getId();
        final Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        return true;
    }

    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final Object other) {
        return other instanceof AbstractEntity;
    }

    @Override
    @SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}
