/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.db.slugable;

import java.lang.reflect.Field;
import javax.inject.Inject;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.reflect.FieldUtils;
import pl.chilldev.commons.db.slugable.Slug;
import pl.chilldev.commons.text.slugifier.SimpleSlugifier;
import pl.chilldev.commons.text.slugifier.Slugifier;

public class SlugableListener {
    @Inject
    private Slugifier slugifier;

    private Slugifier getSlugifier() {
        if (this.slugifier == null) {
            this.slugifier = new SimpleSlugifier();
        }
        return this.slugifier;
    }

    private String generateSlug(String[] texts, Slug options) {
        Slugifier slugifier = this.getSlugifier();
        return options.prefix() + slugifier.slugify(texts) + options.suffix();
    }

    private void fillSlugs(Object slugable, boolean update) throws IllegalAccessException {
        Class<?> type = slugable.getClass();
        for (Field field : FieldUtils.getAllFields(type)) {
            if (!field.isAnnotationPresent(Slug.class)) continue;
            this.fillSlug(field, slugable, update);
        }
    }

    private void fillSlug(Field field, Object slugable, boolean update) throws IllegalAccessException {
        Slug options = field.getDeclaredAnnotation(Slug.class);
        if (!update || options.updatable()) {
            String[] fields = options.value();
            String[] texts = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                texts[i] = FieldUtils.readField((Object)slugable, (String)fields[i], (boolean)true).toString();
            }
            FieldUtils.writeField((Object)slugable, (String)field.getName(), (Object)this.generateSlug(texts, options), (boolean)true);
        }
    }

    @PrePersist
    public void createSlugs(Object slugable) throws IllegalAccessException {
        this.fillSlugs(slugable, false);
    }

    @PreUpdate
    public void updateSlugs(Object slugable) throws IllegalAccessException {
        this.fillSlugs(slugable, true);
    }
}

