/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.client;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoService;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.jsonrpc.mina.IoServiceUtils;
import pl.chilldev.commons.jsonrpc.mina.RequestIoHandler;

public class Connector
implements IoServiceUtils.Configuration {
    public static final int DEFAULT_PACKET_LIMIT = 0x2000000;
    protected Logger logger = LoggerFactory.getLogger(Connector.class);
    protected InetSocketAddress address;
    protected int maxPacketSize = 0x2000000;
    protected NioSocketConnector connector;
    protected RequestIoHandler handler;

    public Connector(NioSocketConnector connector, RequestIoHandler handler, InetSocketAddress address) {
        this.connector = connector;
        this.handler = handler;
        this.address = address;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    @Override
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public Object execute(String method) throws ExecutionException, JSONRPC2Error {
        return this.execute(this.handler.execute(method));
    }

    public Object execute(String method, Map<String, Object> params) throws ExecutionException, JSONRPC2Error {
        return this.execute(this.handler.execute(method, params));
    }

    protected Object execute(FutureTask<JSONRPC2Response> future) throws ExecutionException, JSONRPC2Error {
        try {
            JSONRPC2Response response = future.get();
            if (!response.indicatesSuccess()) {
                JSONRPC2Error error = response.getError();
                this.logger.error("Response ID: {}, error #{}: {}.", new Object[]{response.getID(), error.getCode(), error.getMessage()});
                throw error;
            }
            return response.getResult();
        }
        catch (InterruptedException error) {
            this.logger.error("Error while waiting for asynchronous response: {}.", (Object)error.getMessage());
            throw new ExecutionException(error);
        }
        catch (ExecutionException error) {
            this.logger.error("Error while executing asynchronous response handler: {}.", (Object)error.getMessage());
            throw error;
        }
    }

    public ConnectFuture connect() {
        IoServiceUtils.initialize((IoService)this.connector, (IoHandler)this.handler, this);
        return this.connector.connect((SocketAddress)this.address);
    }

    public void dispose() {
        this.connector.dispose();
    }

    public static Connector create(InetSocketAddress address) {
        return new Connector(new NioSocketConnector(), new RequestIoHandler(), address);
    }
}

