/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.daemon;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonUserSignal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.exception.ExceptionFormatter;
import pl.chilldev.commons.jsonrpc.daemon.Listener;

public abstract class AbstractApplication
implements Daemon,
DaemonUserSignal {
    protected Logger logger = LoggerFactory.getLogger(AbstractApplication.class);
    protected Collection<Listener> threads = new HashSet<Listener>();

    public void start() {
        for (Listener thread : this.buildListeners()) {
            try {
                thread.start();
                this.threads.add(thread);
            }
            catch (Throwable error) {
                this.logger.error("Not starting \"{}\" because of {}.", new Object[]{thread.getName(), ExceptionFormatter.SIMPLE_FORMAT.format(error), error});
            }
        }
        this.logger.trace("Working.");
    }

    public void stop() {
        this.logger.info("Stopping\u2026");
        for (Listener listener : this.threads) {
            listener.release();
        }
        for (Thread thread : this.threads) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException error) {
                this.logger.error("Had to interrupt while waiting for thread \"{}\".", (Object)thread.getName(), (Object)error);
            }
        }
        this.threads.clear();
    }

    public void signal() {
        this.logger.info("Handling configuration reload.");
        this.stop();
        this.start();
    }

    public void init(DaemonContext context) {
        this.logger.info("Started {} daemon v.{} on {} {} ({}) / Java {} ({}).", new Object[]{this.getDaemonName(), this.getDaemonVersion(), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.version"), System.getProperty("java.vendor")});
    }

    public void destroy() {
    }

    protected abstract String getDaemonName();

    protected abstract String getDaemonVersion();

    protected abstract Collection<Listener> buildListeners();
}

