/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.daemon;

import java.util.Collection;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import pl.chilldev.commons.jsonrpc.daemon.AbstractApplication;
import pl.chilldev.commons.jsonrpc.daemon.Listener;

public abstract class AbstractSpringApplication
extends AbstractApplication {
    protected AnnotationConfigApplicationContext context;

    @Override
    public void start() {
        this.logger.info("Loading application context.");
        this.context = new AnnotationConfigApplicationContext();
        this.context.scan(new String[]{this.getPackageToScan()});
        this.context.refresh();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.context != null) {
            this.context.close();
        }
    }

    @Override
    protected Collection<Listener> buildListeners() {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.context, Listener.class).values();
    }

    protected abstract String getPackageToScan();
}

