/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.mina;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.jsonrpc.daemon.ContextInterface;
import pl.chilldev.commons.jsonrpc.rpc.Dispatcher;

public class DispatcherIoHandler<ContextType extends ContextInterface>
extends IoHandlerAdapter {
    protected Logger logger = LoggerFactory.getLogger(DispatcherIoHandler.class);
    protected ContextType context;
    protected Dispatcher<? super ContextType> dispatcher;

    public DispatcherIoHandler(ContextType context, Dispatcher<? super ContextType> dispatcher) {
        this.context = context;
        this.dispatcher = dispatcher;
    }

    public void exceptionCaught(IoSession session, Throwable error) {
        this.logger.error("Session ID {}: connection exteption.", (Object)session.getId(), (Object)error);
        session.write((Object)new JSONRPC2Response(JSONRPC2Error.INTERNAL_ERROR, null));
        session.close(false);
    }

    public void messageReceived(IoSession session, Object message) {
        JSONRPC2Response response = null;
        try {
            JSONRPC2Request request = JSONRPC2Request.parse((String)message.toString());
            this.logger.debug("Session ID {}: JSON request: {}.", (Object)session.getId(), (Object)request);
            response = this.dispatcher.dispatch(request, this.context);
            this.logger.debug("JSON response: {}.", (Object)response);
        }
        catch (JSONRPC2ParseException error) {
            response = new JSONRPC2Response(JSONRPC2Error.PARSE_ERROR, null);
            this.logger.error("Could not parse JSON-RPC request.");
            this.logger.debug("Session ID {}: malformed JSON request: {}.", (Object)session.getId(), message);
        }
        session.write((Object)response);
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        this.logger.info("Session ID {}: closing idle connection.", (Object)session.getId());
        session.close(true);
    }

    public void sessionOpened(IoSession session) {
        this.logger.info("New connection from {}, connection ID: {}.", (Object)session.getRemoteAddress(), (Object)session.getId());
    }
}

