/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.mina;

import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeoutException;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.concurrent.FutureResponder;

public class RequestIoHandler
extends IoHandlerAdapter {
    private static long id;
    protected Logger logger = LoggerFactory.getLogger(RequestIoHandler.class);
    protected Map<Object, FutureResponder<JSONRPC2Response>> responses = new HashMap<Object, FutureResponder<JSONRPC2Response>>();
    protected IoSession session;

    protected static long generateRequestId() {
        return id++;
    }

    public FutureTask<JSONRPC2Response> execute(String method) {
        long id = RequestIoHandler.generateRequestId();
        return this.execute(new JSONRPC2Request(method, (Object)id));
    }

    public FutureTask<JSONRPC2Response> execute(String method, Map<String, Object> params) {
        long id = RequestIoHandler.generateRequestId();
        return this.execute(new JSONRPC2Request(method, params, (Object)id));
    }

    protected FutureTask<JSONRPC2Response> execute(JSONRPC2Request request) {
        if (this.session == null) {
            throw new IllegalStateException("Could not execute JSON-RPC request - client is not yet connected.");
        }
        FutureResponder responder = new FutureResponder();
        FutureTask<JSONRPC2Response> future = new FutureTask<JSONRPC2Response>((Callable<JSONRPC2Response>)responder);
        responder.setFuture(future);
        this.responses.put(request.getID(), (FutureResponder<JSONRPC2Response>)responder);
        this.logger.debug("Session ID {}: JSON request: {}.", (Object)this.session.getId(), (Object)request);
        this.session.write((Object)request);
        return future;
    }

    public void sessionOpened(IoSession session) {
        this.logger.info("New connection to {}, connection ID: {}.", (Object)session.getRemoteAddress(), (Object)session.getId());
        this.session = session;
    }

    public void messageReceived(IoSession session, Object message) throws JSONRPC2ParseException {
        try {
            JSONRPC2Response response = JSONRPC2Response.parse((String)message.toString());
            this.logger.debug("Session ID {}: JSON response: {}.", (Object)session.getId(), (Object)response);
            this.responses.get(response.getID()).setResponse((Object)response);
            this.responses.remove(response.getID());
        }
        catch (JSONRPC2ParseException error) {
            this.logger.error("Could not parse JSON-RPC response.");
            this.logger.debug("Session ID {}: malformed JSON response: {}.", (Object)session.getId(), message);
            throw error;
        }
    }

    public void exceptionCaught(IoSession session, Throwable error) throws Exception {
        this.logger.error("Session ID {}: connection exteption.", (Object)session.getId(), (Object)error);
        session.close(false);
        throw new Exception(error);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws TimeoutException {
        this.logger.warn("Session ID {}: closing idle connection.", (Object)session.getId());
        session.close(true);
        throw new TimeoutException(String.format("Connection timeout out: session ID %s.", session.getId()));
    }
}

