/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.rpc;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import java.util.HashMap;
import java.util.Map;
import pl.chilldev.commons.jsonrpc.daemon.ContextInterface;
import pl.chilldev.commons.jsonrpc.rpc.ReturningMethod;
import pl.chilldev.commons.jsonrpc.rpc.VoidMethod;

public class Dispatcher<ContextType extends ContextInterface> {
    protected Map<String, RequestHandler<? super ContextType>> handlers = new HashMap<String, RequestHandler<? super ContextType>>();

    public void register(String method, RequestHandler<? super ContextType> handler) {
        this.handlers.put(method, handler);
    }

    public void register(String method, ReturningMethod<? super ContextType> rpcMethod) {
        this.register(method, new ReturningMethod.RequestHandler<ContextType>(rpcMethod));
    }

    public void register(String method, VoidMethod<? super ContextType> rpcMethod) {
        this.register(method, new VoidMethod.RequestHandler<ContextType>(rpcMethod));
    }

    public JSONRPC2Response dispatch(JSONRPC2Request request, ContextType context) {
        String method = request.getMethod();
        if (this.handlers.containsKey(method)) {
            try {
                return this.handlers.get(method).process(request, context);
            }
            catch (JSONRPC2Error error) {
                return new JSONRPC2Response(error, request.getID());
            }
        }
        return new JSONRPC2Response(JSONRPC2Error.METHOD_NOT_FOUND, request.getID());
    }

    public static interface RequestHandler<ContextType extends ContextInterface> {
        public JSONRPC2Response process(JSONRPC2Request var1, ContextType var2) throws JSONRPC2Error;
    }
}

