/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.daemon;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.service.IoService;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.jsonrpc.daemon.ContextInterface;
import pl.chilldev.commons.jsonrpc.mina.DispatcherIoHandler;
import pl.chilldev.commons.jsonrpc.mina.IoServiceUtils;
import pl.chilldev.commons.jsonrpc.rpc.Dispatcher;

public class Listener<ContextType extends ContextInterface>
extends Thread
implements IoServiceUtils.Configuration {
    public static final int SLEEP_TICK = 500;
    public static final int DEFAULT_PACKET_LIMIT = 0x2000000;
    protected Logger logger = LoggerFactory.getLogger(Listener.class);
    protected ContextType context;
    protected Dispatcher<? super ContextType> dispatcher;
    protected int sleepTick = 500;
    protected InetSocketAddress address;
    protected int maxPacketSize = 0x2000000;
    protected boolean running = true;

    public Listener(String name, ContextType context, Dispatcher<? super ContextType> dispatcher) {
        super(name);
        this.context = context;
        this.dispatcher = dispatcher;
    }

    public void setSleepTick(int sleepTick) {
        this.sleepTick = sleepTick;
    }

    public void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    @Override
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public Listener release() {
        this.running = false;
        return this;
    }

    @Override
    public void run() {
        if (this.address == null) {
            this.logger.info("\"{}\" was not enabled for connection, no point to start it.", (Object)this.getName());
            return;
        }
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        try {
            IoServiceUtils.initialize((IoService)acceptor, new DispatcherIoHandler<ContextType>(this.context, this.dispatcher), this);
            acceptor.setReuseAddress(true);
            acceptor.bind((SocketAddress)this.address);
            this.logger.info("Started.");
            try {
                while (this.running) {
                    Listener.sleep(this.sleepTick);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (IOException error) {
            this.logger.error("IO connection error: {}.", (Object)error.getMessage());
        }
        finally {
            acceptor.unbind();
            acceptor.dispose();
        }
    }
}

