/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.client;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.jsonrpc.client.RpcCallException;
import pl.chilldev.commons.jsonrpc.mina.IoServiceUtils;
import pl.chilldev.commons.jsonrpc.mina.RequestIoHandler;

public class Connector
implements IoServiceUtils.Configuration {
    public static final int DEFAULT_PACKET_LIMIT = 0x2000000;
    private static long id;
    protected Logger logger = LoggerFactory.getLogger(Connector.class);
    protected InetSocketAddress address;
    protected int maxPacketSize = 0x2000000;
    protected NioSocketConnector connector;
    protected RequestIoHandler handler;
    protected IoSession session;

    public Connector(NioSocketConnector connector, RequestIoHandler handler, InetSocketAddress address) {
        this.connector = connector;
        this.handler = handler;
        this.address = address;
        IoServiceUtils.initialize((IoService)this.connector, (IoHandler)this.handler, this);
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    @Override
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public Object execute(String method) throws RpcCallException {
        long id = Connector.generateRequestId();
        return this.execute(new JSONRPC2Request(method, (Object)id));
    }

    public Object execute(String method, Map<String, Object> params) throws RpcCallException {
        long id = Connector.generateRequestId();
        return this.execute(new JSONRPC2Request(method, params, (Object)id));
    }

    protected Object execute(JSONRPC2Request request) throws RpcCallException {
        if (this.session == null || !this.session.isConnected()) {
            this.reconnect(this.connect());
        }
        try {
            FutureTask<JSONRPC2Response> future = this.handler.execute(request);
            this.session.write((Object)request);
            JSONRPC2Response response = future.get();
            if (!response.indicatesSuccess()) {
                JSONRPC2Error error = response.getError();
                this.logger.error("Response ID: {}, error #{}: {}.", new Object[]{response.getID(), error.getCode(), error.getMessage()});
                throw error;
            }
            return response.getResult();
        }
        catch (InterruptedException error) {
            this.logger.error("Error while waiting for asynchronous response: {}.", (Object)error.getMessage());
            throw new RpcCallException(error);
        }
        catch (ExecutionException error) {
            this.logger.error("Error while executing asynchronous response handler: {}.", (Object)error.getMessage());
            throw new RpcCallException(error);
        }
        catch (JSONRPC2Error error) {
            this.logger.error("Server returned error response: {}.", (Object)error.getMessage());
            throw new RpcCallException((Exception)((Object)error));
        }
    }

    public ConnectFuture connect() {
        return this.connector.connect((SocketAddress)this.address);
    }

    public void reconnect(ConnectFuture future) {
        this.session = future.awaitUninterruptibly().getSession();
    }

    public void dispose() {
        this.connector.dispose();
    }

    public static Connector create(InetSocketAddress address) {
        return new Connector(new NioSocketConnector(), new RequestIoHandler(), address);
    }

    public static Connector create(String host, int port) {
        return Connector.create(new InetSocketAddress(host, port));
    }

    protected static long generateRequestId() {
        return id++;
    }
}

