/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParamsType;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.util.NamedParamsRetriever;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class ParamsRetriever
extends NamedParamsRetriever {
    public static final String DEFAULTPARAM_PAGE = "page";
    public static final String DEFAULTPARAM_LIMIT = "limit";
    public static final String DEFAULTPARAM_SORT = "sort";
    public static final String DEFAULTPARAM_RECORDS = "records";
    public static final String DEFAULTPARAM_COUNT = "count";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ParamsRetriever(Map<String, Object> params) {
        super(params);
    }

    public ParamsRetriever(JSONRPC2Request request) {
        super(request.getParamsType() == JSONRPC2ParamsType.NO_PARAMS ? new HashMap() : request.getNamedParams());
    }

    public UUID getUuid(String param) throws JSONRPC2Error {
        return this.getUuid(param, false);
    }

    public UUID getUuid(String param, boolean allowNull) throws JSONRPC2Error {
        String uuid = this.getString(param, allowNull);
        return ParamsRetriever.parseUuid(param, uuid, allowNull);
    }

    public UUID getOptUuid(String param) throws JSONRPC2Error {
        return this.getOptUuid(param, false);
    }

    public UUID getOptUuid(String param, boolean allowNull) throws JSONRPC2Error {
        if (!this.hasParam(param)) {
            return null;
        }
        String uuid = this.getOptString(param, allowNull, null);
        return ParamsRetriever.parseUuid(param, uuid, allowNull);
    }

    protected static UUID parseUuid(String param, String value, boolean allowNull) throws JSONRPC2Error {
        try {
            if (allowNull && value == null) {
                return null;
            }
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException error) {
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(String.format(": Parameter \"%s\" is not valid UUID.", param));
        }
    }

    public Sort getSort(String param) throws JSONRPC2Error {
        ArrayList<Sort.Order> sort = new ArrayList<Sort.Order>();
        for (Object order : this.getOptList(param, Collections.emptyList())) {
            if (order instanceof List) {
                List property = (List)order;
                sort.add(new Sort.Order(Sort.Direction.valueOf((String)property.get(1).toString()), property.get(0).toString()));
                continue;
            }
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(String.format(": Parameter \"%s\" is not valid Sort definition.", param));
        }
        return sort.size() > 0 ? new Sort(sort) : null;
    }

    public Pageable getPageable(String pageParam, String limitParam, String sortParam, int defaultLimit) throws JSONRPC2Error {
        return new PageRequest(this.getOptInt(pageParam, 0), this.getOptInt(limitParam, defaultLimit), this.getSort(sortParam));
    }

    public Pageable getPageable(int defaultLimit) throws JSONRPC2Error {
        return this.getPageable(DEFAULTPARAM_PAGE, DEFAULTPARAM_LIMIT, DEFAULTPARAM_SORT, defaultLimit);
    }

    public <Type> Type getBean(Class<Type> type) {
        return (Type)OBJECT_MAPPER.convertValue((Object)this.getParams(), type);
    }

    public <Type> Type getBean(String param, Class<Type> type, boolean allowNull) throws JSONRPC2Error {
        Map data = this.getMap(param, allowNull);
        if (data == null) {
            return null;
        }
        return new ParamsRetriever(data).getBean(type);
    }

    public <Type> Type getBean(String param, Class<Type> type) throws JSONRPC2Error {
        return this.getBean(param, type, false);
    }
}

