/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.client.introspector;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import pl.chilldev.commons.jsonrpc.client.Connector;
import pl.chilldev.commons.jsonrpc.client.introspector.ParameterMapper;
import pl.chilldev.commons.jsonrpc.rpc.introspector.JsonRpcCall;
import pl.chilldev.commons.jsonrpc.rpc.introspector.JsonRpcParam;

public class Introspector {
    public static final Introspector DEFAULT_INTROSPECTOR = Introspector.createDefault();
    private static final ParameterMapper<Object> DEFAULT_MAPPER = (name, value, params) -> params.put(name, value);
    private static final Function<Object, Object> IDENTITY_HANDLER = value -> value;
    private Logger logger = LoggerFactory.getLogger(Introspector.class);
    private Map<Class<?>, ParameterMapper<Object>> mappers = new HashMap();
    private Map<Class<?>, Function<Object, ?>> handlers = new HashMap();

    public <Type> void registerParameterMapper(Class<Type> type, ParameterMapper<? super Type> mapper) {
        this.mappers.put(type, (name, value, params) -> mapper.putParam(name, (Object)type.cast(value), params));
    }

    public <Type> void registerResultHandler(Class<Type> type, Function<Object, ? extends Type> handler) {
        this.handlers.put(type, handler);
    }

    public <Type> Class<? extends Type> createClient(Class<Type> type, Connector connector) {
        return new ByteBuddy().subclass(type).method((ElementMatcher)ElementMatchers.isAnnotatedWith(JsonRpcCall.class)).intercept((Implementation)MethodDelegation.to((Object)this.buildClient(type, connector))).make().load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
    }

    private Client buildClient(Class<?> type, Connector connector) {
        Client client = new Client(connector);
        for (Method method : type.getMethods()) {
            if (!method.isAnnotationPresent(JsonRpcCall.class)) continue;
            this.logger.debug("Found {}.{} method as JSON-RPC request.", (Object)type.getName(), (Object)method.getName());
            JsonRpcCall call = method.getAnnotation(JsonRpcCall.class);
            Parameter[] parameters = method.getParameters();
            ArrayList<ParameterMapperWrapper<Object>> mappers = new ArrayList<ParameterMapperWrapper<Object>>(parameters.length);
            for (Parameter parameter : parameters) {
                mappers.add(this.createParameterMapper(parameter));
            }
            Class<?> response = method.getReturnType();
            Function<Object, Object> handler = this.handlers.containsKey(response) ? this.handlers.get(response) : IDENTITY_HANDLER;
            client.register(method, new Call("".equals(call.name()) ? method.getName() : call.name(), mappers, handler));
        }
        return client;
    }

    private ParameterMapperWrapper<Object> createParameterMapper(Parameter parameter) {
        Class<?> type = parameter.getType();
        ParameterMapper<Object> mapper = this.mappers.containsKey(type) ? this.mappers.get(type) : DEFAULT_MAPPER;
        String name = parameter.getName();
        JsonRpcParam metadata = parameter.getAnnotation(JsonRpcParam.class);
        if (metadata != null) {
            name = "".equals(metadata.name()) ? name : metadata.name();
        }
        return this.createParameterMapperWrapper(mapper, name);
    }

    private <Type> ParameterMapperWrapper<Type> createParameterMapperWrapper(ParameterMapper<? super Type> mapper, String name) {
        return (value, params) -> mapper.putParam(name, value, params);
    }

    private static Introspector createDefault() {
        Introspector introspector = new Introspector();
        introspector.registerParameterMapper(Pageable.class, (name, value, params) -> {
            params.put("page", value.getPageNumber());
            params.put("limit", value.getPageSize());
            params.put("sort", value.getSort());
        });
        introspector.registerResultHandler(UUID.class, response -> UUID.fromString(response.toString()));
        return introspector;
    }

    public static class Client {
        private Connector connector;
        private Map<Method, Call> calls = new HashMap<Method, Call>();

        Client(Connector connector) {
            this.connector = connector;
        }

        public void register(Method method, Call call) {
            this.calls.put(method, call);
        }

        @RuntimeType
        public Object execute(@Origin Method method, @AllArguments Object[] arguments) {
            return this.calls.get(method).execute(this.connector, arguments);
        }
    }

    static class Call {
        private String name;
        private List<ParameterMapperWrapper<Object>> params;
        private Function<Object, ?> handler;

        Call(String name, List<ParameterMapperWrapper<Object>> params, Function<Object, ?> handler) {
            this.name = name;
            this.params = params;
            this.handler = handler;
        }

        public Object execute(Connector connector, Object[] arguments) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (int i = 0; i < arguments.length; ++i) {
                this.params.get(i).putParam(arguments[i], params);
            }
            return this.handler.apply(params.isEmpty() ? connector.execute(this.name) : connector.execute(this.name, params));
        }
    }

    @FunctionalInterface
    static interface ParameterMapperWrapper<Type> {
        public void putParam(Type var1, Map<String, Object> var2);
    }
}

