/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.mina;

import java.nio.charset.StandardCharsets;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoService;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;

public class IoServiceUtils {
    private static final String CHAIN_CODEC = "codec";

    public static void initialize(IoService service, IoHandler handler, Configuration config) {
        TextLineCodecFactory codec = new TextLineCodecFactory(StandardCharsets.UTF_8);
        codec.setDecoderMaxLineLength(config.getMaxPacketSize());
        codec.setEncoderMaxLineLength(config.getMaxPacketSize());
        service.getFilterChain().addLast(CHAIN_CODEC, (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)codec));
        service.setHandler(handler);
    }

    public static interface Configuration {
        public int getMaxPacketSize();
    }
}

