/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.mina;

import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeoutException;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.concurrent.FutureResponder;
import pl.chilldev.commons.jsonrpc.rpc.ErrorCodes;

public class RequestIoHandler
extends IoHandlerAdapter {
    private Logger logger = LoggerFactory.getLogger(RequestIoHandler.class);
    private Map<Object, FutureResponder<JSONRPC2Response>> responses = new HashMap<Object, FutureResponder<JSONRPC2Response>>();

    public FutureTask<JSONRPC2Response> execute(JSONRPC2Request request) {
        FutureResponder responder = new FutureResponder();
        FutureTask<JSONRPC2Response> future = new FutureTask<JSONRPC2Response>((Callable<JSONRPC2Response>)responder);
        responder.setFuture(future);
        this.responses.put(request.getID(), (FutureResponder<JSONRPC2Response>)responder);
        return future;
    }

    public void sessionOpened(IoSession session) {
        this.logger.info("New connection to {}, connection ID: {}.", (Object)session.getRemoteAddress(), (Object)session.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoSession session) {
        this.logger.debug("Connection to {} closed, connection ID: {}.", (Object)session.getRemoteAddress(), (Object)session.getId());
        Map<Object, FutureResponder<JSONRPC2Response>> map = this.responses;
        synchronized (map) {
            for (Map.Entry<Object, FutureResponder<JSONRPC2Response>> entry : this.responses.entrySet()) {
                this.logger.error("Terminating request ID {}: lost connection.", entry.getKey());
                entry.getValue().setResponse((Object)new JSONRPC2Response(ErrorCodes.ERROR_CONNECTION.appendMessage(": lost connection."), entry.getKey()));
            }
            this.responses.clear();
        }
    }

    public void messageSent(IoSession session, Object message) {
        this.logger.debug("Session ID {}: JSON request: {}.", (Object)session.getId(), message);
    }

    public void messageReceived(IoSession session, Object message) throws JSONRPC2ParseException {
        try {
            JSONRPC2Response response = JSONRPC2Response.parse((String)message.toString());
            this.logger.debug("Session ID {}: JSON response: {}.", (Object)session.getId(), (Object)response);
            Object id = response.getID();
            if (this.responses.containsKey(id)) {
                this.responses.get(id).setResponse((Object)response);
                this.responses.remove(id);
            } else {
                this.logger.warn("Session ID {}: response for unknown request ID {}.", (Object)session.getId(), id);
            }
        }
        catch (JSONRPC2ParseException error) {
            this.logger.error("Could not parse JSON-RPC response.");
            this.logger.debug("Session ID {}: malformed JSON response: {}.", (Object)session.getId(), message);
            throw error;
        }
    }

    public void exceptionCaught(IoSession session, Throwable error) throws Exception {
        this.logger.error("Session ID {}: connection exteption.", (Object)session.getId(), (Object)error);
        session.close(false);
        throw new Exception(error);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws TimeoutException {
        this.logger.warn("Session ID {}: closing idle connection.", (Object)session.getId());
        session.close(true);
        throw new TimeoutException(String.format("Connection timeout out: session ID %s.", session.getId()));
    }
}

