/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.client;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.jsonrpc.client.RpcCallException;
import pl.chilldev.commons.jsonrpc.netty.RequestHandler;
import pl.chilldev.commons.jsonrpc.netty.StringChannelInitializer;

public class Connector
implements StringChannelInitializer.Configuration {
    public static final int DEFAULT_PACKET_LIMIT = 0x2000000;
    private static long id;
    private Logger logger = LoggerFactory.getLogger(Connector.class);
    private SocketAddress address;
    private int maxPacketSize = 0x2000000;
    private Bootstrap bootstrap = new Bootstrap();
    private RequestHandler handler;
    private Channel session;

    public Connector(EventLoopGroup connectors, RequestHandler handler, SocketAddress address) {
        this.handler = handler;
        this.address = address;
        ((Bootstrap)((Bootstrap)this.bootstrap.group(connectors)).channel(NioSocketChannel.class)).handler(new StringChannelInitializer((ChannelHandler)this.handler, this));
    }

    public Object execute(String method) {
        long id = Connector.generateRequestId();
        return this.execute(new JSONRPC2Request(method, (Object)id));
    }

    public Object execute(String method, Map<String, Object> params) {
        long id = Connector.generateRequestId();
        return this.execute(new JSONRPC2Request(method, params, (Object)id));
    }

    private Object execute(JSONRPC2Request request) {
        if (this.session == null || !this.session.isActive()) {
            this.reconnect(this.connect());
        }
        try {
            Future<JSONRPC2Response> future = this.handler.execute(request);
            this.session.writeAndFlush((Object)request);
            JSONRPC2Response response = future.get();
            if (!response.indicatesSuccess()) {
                JSONRPC2Error error = response.getError();
                this.logger.error("Response ID: {}, error #{}: {}.", new Object[]{response.getID(), error.getCode(), error.getMessage()});
                throw error;
            }
            return response.getResult();
        }
        catch (InterruptedException error) {
            this.logger.error("Error while waiting for asynchronous response: {}.", (Object)error.getMessage());
            throw new RpcCallException(error);
        }
        catch (ExecutionException error) {
            this.logger.error("Error while executing asynchronous response handler: {}.", (Object)error.getMessage());
            throw new RpcCallException(error.getCause());
        }
        catch (JSONRPC2Error error) {
            this.logger.error("Server returned error response: {}.", (Object)error.getMessage());
            throw new RpcCallException(error);
        }
    }

    public ChannelFuture connect() {
        return this.bootstrap.connect(this.address);
    }

    public void reconnect(ChannelFuture future) {
        this.session = future.syncUninterruptibly().channel();
    }

    public static Connector create(EventLoopGroup connectors, SocketAddress address) {
        return new Connector(connectors, new RequestHandler(), address);
    }

    public static Connector create(EventLoopGroup connectors, String host, int port) {
        return Connector.create(connectors, new InetSocketAddress(host, port));
    }

    private static long generateRequestId() {
        return id++;
    }

    @Override
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }
}

