/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.daemon;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonUserSignal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.jsonrpc.daemon.Listener;

public abstract class AbstractApplication
implements Daemon,
DaemonUserSignal {
    protected Logger logger = LoggerFactory.getLogger(AbstractApplication.class);
    private Collection<Listener<?>> listeners = new HashSet();
    private EventLoopGroup acceptors;
    private EventLoopGroup workers;
    private int acceptorsCount;
    private int workersCount;

    public void start() {
        this.acceptors = new NioEventLoopGroup(this.acceptorsCount);
        this.workers = new NioEventLoopGroup(this.workersCount);
        for (Listener<?> listener : this.buildListeners()) {
            try {
                listener.start(this.acceptors, this.workers);
                this.listeners.add(listener);
            }
            catch (Exception error) {
                this.logger.error("Not starting \"{}\" because of {}.", new Object[]{listener.getName(), error.getMessage(), error});
            }
        }
        this.logger.trace("Working.");
    }

    public void stop() {
        this.logger.info("Stopping\u2026");
        for (Listener<?> listener : this.listeners) {
            try {
                listener.stop();
            }
            catch (InterruptedException error) {
                this.logger.error("Had to interrupt while waiting for thread \"{}\".", (Object)listener.getName(), (Object)error);
            }
        }
        this.listeners.clear();
        if (this.acceptors != null) {
            this.acceptors.shutdownGracefully();
        }
        if (this.workers != null) {
            this.workers.shutdownGracefully();
        }
    }

    public void signal() {
        this.logger.info("Handling configuration reload.");
        this.stop();
        this.start();
    }

    public void init(DaemonContext context) {
        this.logger.info("Started {} daemon v.{} on {} {} ({}) / Java {} ({}).", new Object[]{this.getDaemonName(), this.getDaemonVersion(), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.version"), System.getProperty("java.vendor")});
    }

    public void destroy() {
    }

    protected abstract String getDaemonName();

    protected abstract String getDaemonVersion();

    protected abstract Collection<Listener<?>> buildListeners();

    public void setAcceptorsCount(int acceptorsCount) {
        this.acceptorsCount = acceptorsCount;
    }

    public void setWorkersCount(int workersCount) {
        this.workersCount = workersCount;
    }
}

