/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.daemon;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import pl.chilldev.commons.jsonrpc.daemon.AbstractApplication;
import pl.chilldev.commons.jsonrpc.daemon.Listener;

public abstract class AbstractSpringApplication
extends AbstractApplication {
    private AnnotationConfigApplicationContext context;

    @Override
    public void start() {
        this.logger.info("Loading application context.");
        this.context = new AnnotationConfigApplicationContext();
        this.context.scan(new String[]{this.getPackageToScan()});
        this.context.refresh();
        for (ApplicationConfigurer configurer : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.context, ApplicationConfigurer.class).values()) {
            configurer.configureApplication(this);
        }
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.context != null) {
            this.context.close();
        }
    }

    @Override
    protected Collection<Listener<?>> buildListeners() {
        ArrayList listeners = new ArrayList();
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.context, Listener.class).values().forEach(listeners::add);
        return listeners;
    }

    protected String getPackageToScan() {
        return this.getClass().getPackage().getName();
    }

    @FunctionalInterface
    public static interface ApplicationConfigurer {
        public void configureApplication(AbstractApplication var1);
    }
}

