/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.daemon;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.jsonrpc.daemon.ContextInterface;
import pl.chilldev.commons.jsonrpc.netty.DispatcherHandler;
import pl.chilldev.commons.jsonrpc.netty.StringChannelInitializer;
import pl.chilldev.commons.jsonrpc.rpc.Dispatcher;

public class Listener<ContextType extends ContextInterface>
implements StringChannelInitializer.Configuration {
    public static final int DEFAULT_PACKET_LIMIT = 0x2000000;
    public static final ChannelHandler LOGGING_HANDLER = new LoggingHandler(Listener.class);
    private Logger logger = LoggerFactory.getLogger(Listener.class);
    private String name;
    private ContextType context;
    private Dispatcher<? super ContextType> dispatcher;
    private Channel channel;
    private SocketAddress address;
    private int maxPacketSize = 0x2000000;

    public Listener(String name, ContextType context, Dispatcher<? super ContextType> dispatcher) {
        this.name = name;
        this.context = context;
        this.dispatcher = dispatcher;
    }

    public synchronized Listener<ContextType> stop() throws InterruptedException {
        if (this.channel != null) {
            this.channel.close().sync();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(EventLoopGroup acceptors, EventLoopGroup workers) throws InterruptedException {
        if (this.address == null) {
            this.logger.info("\"{}\" was not enabled for connection, no point to start it.", (Object)this.getName());
            return;
        }
        Listener listener = this;
        synchronized (listener) {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(acceptors, workers).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).handler(LOGGING_HANDLER)).childHandler(new StringChannelInitializer((ChannelHandler)new DispatcherHandler<ContextType>(this.context, this.dispatcher), this));
            this.channel = bootstrap.bind(this.address).sync().channel();
        }
        this.logger.info("Started.");
    }

    public String getName() {
        return this.name;
    }

    public void setAddress(SocketAddress address) {
        this.address = address;
    }

    @Override
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }
}

