/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.json;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import pl.chilldev.commons.jsonrpc.json.ParamsRetriever;

public class ConvertUtils {
    public static <Type> Page<Type> buildPage(Object result, Pageable request, Class<Type> type, String recordsParam, String countParam) {
        if (!(result instanceof Map)) {
            throw new ClassCastException(String.format("Result returned from server is not a dictionary of returned value: %s found.", result.getClass().getName()));
        }
        Map params = (Map)result;
        Object data = params.get(recordsParam);
        if (!(data instanceof List)) {
            throw new ClassCastException(String.format("Value returned under key \"%s\" is not a list of records: %s found.", recordsParam, data.getClass().getName()));
        }
        List records = (List)data;
        List list = records.stream().map(record -> ParamsRetriever.OBJECT_MAPPER.convertValue(record, type)).collect(Collectors.toList());
        return new PageImpl(list, request, Long.parseLong(params.get(countParam).toString()));
    }

    public static <Type> Page<Type> buildPage(Object result, Pageable request, Class<Type> type) {
        return ConvertUtils.buildPage(result, request, type, "records", "count");
    }

    public static <LocalType, TransferType> TransferType dump(LocalType entity, Converter<LocalType, TransferType> strategy) {
        if (entity == null) {
            return null;
        }
        return (TransferType)strategy.convert(entity);
    }
}

